package com.artfess.yhxt.statistics.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.statistics.manager.BaseDataStatisticsManager;
import com.artfess.yhxt.statistics.model.CamerasRequest;
import com.artfess.yhxt.statistics.model.ParamEntity;
import com.artfess.yhxt.statistics.model.PreviewURLsRequest;
import com.artfess.yhxt.statistics.model.WorkStatistic;
import com.artfess.yhxt.statistics.vo.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * @author zhx
 * @create 2021/9/1
 */
@RestController
@RequestMapping("/baseDataStatistics/v1/")
@Api(tags = "基础数据统计接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BaseDataStatisticsController {
    @Resource
    private BaseDataStatisticsManager baseDataStatisticsManager;

    @RequestMapping(value = "getBridgeStatistics", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "桥梁统计", httpMethod = "POST")
    public Map<String, List> getBridgeStatistics(@ApiParam(name = "map", value = "roadSegmentId:路段id companyId:公司id")
                                                 @RequestBody Map<String, Object> map) {
        return this.baseDataStatisticsManager.getBridgeStatistics(map);
    }

    @RequestMapping(value = "getTunnelStatistics", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "隧道统计", httpMethod = "POST")
    public Map<String, List> getTunnelStatistics(@ApiParam(name = "map", value = "roadSegmentId:路段id companyId:公司id")
                                                 @RequestBody Map<String, Object> map) {
        return this.baseDataStatisticsManager.getTunnelStatistics(map);
    }


    @RequestMapping(value = "/export", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "桥梁上部结构数据导出", httpMethod = "POST", notes = "桥梁上部结构数据导出")
    public void export(HttpServletResponse response, @ApiParam(name = "map", value = "roadSegmentId:路段id companyId:公司id")
    @RequestBody Map<String, Object> map) throws Exception {
        this.baseDataStatisticsManager.export(response, map);
    }

    //边坡、沿线、路段
    //桥梁、隧道、涵洞
    @RequestMapping(value = "/getAllStructureCount", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "各个结构数量", httpMethod = "POST", notes = "各个结构数量")
    public Map<String, List> getAllStructureCount(@ApiParam(name = "map",
            value = "roadSegmentId:路段id companyId:公司id routeId:路线ID")
                                                  @RequestBody Map<String, Object> map) throws Exception {
        return this.baseDataStatisticsManager.getAllStructureCount(map);
    }

    @RequestMapping(value = "/getSideSlopCompany", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "各个分公司边坡是否高危数量查询", httpMethod = "POST", notes = "各个分公司边坡是否高危数量查询")
    public Map<String, List> getSideSlopCompany() throws Exception {
        return this.baseDataStatisticsManager.getSideSlopCompany();
    }

    @RequestMapping(value = "/getRoadsideFacilitiesCompany", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "各个分公司沿线设施数量查询", httpMethod = "POST", notes = "各个分公司沿线设施数量查询")
    public Map<String, List> getRoadsideFacilitiesCompany() throws Exception {
        return this.baseDataStatisticsManager.getRoadsideFacilitiesCompany();
    }


    @RequestMapping(value = "/getRoadSectionCompany", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "各个分公司沿线设施数量查询", httpMethod = "POST", notes = "各个分公司沿线设施数量查询")
    public Map<String, List> getRoadSectionCompany() throws Exception {
        return this.baseDataStatisticsManager.getRoadSectionCompany();
    }

    @RequestMapping(value = "/getBridgeCompany", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "各个分公司桥梁数量查询", httpMethod = "POST", notes = "各个分公司桥梁数量查询")
    public Map<String, List> getBridgeCompany() throws Exception {

        return this.baseDataStatisticsManager.getBridgeCompany();
    }

    @RequestMapping(value = "/getTunnelCompany", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "各个分公司隧道数量查询", httpMethod = "POST", notes = "各个分公司隧道数量查询")
    public Map<String, List> getTunnelCompany() throws Exception {

        return this.baseDataStatisticsManager.getTunnelCompany();
    }

    @RequestMapping(value = "/getCulvertCompany", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "各个分公司涵洞数量查询", httpMethod = "POST", notes = "各个分公司隧道数量查询")
    public Map<String, List> getCulvertCompany() throws Exception {
        return this.baseDataStatisticsManager.getCulvertCompany();
    }

    @RequestMapping(value = "/getBridgeTunnelCountRanking", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "桥梁隧道数量排行", httpMethod = "POST", notes = "桥梁隧道数量排行")
    public Map<String, List> getBridgeTunnelCountRanking() throws Exception {
        return this.baseDataStatisticsManager.getBridgeTunnelCountRanking();
    }

    @RequestMapping(value = "/getMileage", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "里程排行统计", httpMethod = "POST", notes = "里程排行统计")
    public List<MileageVo> getMileage(@RequestBody BaseDataParamVo baseDataParamVo) throws Exception {
        return this.baseDataStatisticsManager.getRoadMileageCount(baseDataParamVo);
    }



    @RequestMapping(value = "/getMaintenanceStation", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "养护站个数统计", httpMethod = "POST", notes = "养护站个数统计")
    public List<MaintenanceStationVo> getMaintenanceStation(@RequestBody BaseDataParamVo baseDataParamVo) throws Exception {
        return this.baseDataStatisticsManager.getMaintenanceStation(baseDataParamVo);
    }

    @RequestMapping(value = "/getUserCount", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "各个公司人员查询", httpMethod = "POST", notes = "各个公司人员查询")
    public List<CompanyUserVo> getUserCount(@RequestBody BaseDataParamVo baseDataParamVo) throws Exception {
        return this.baseDataStatisticsManager.getUserCount(baseDataParamVo);
    }

    @RequestMapping(value = "/getRoad", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "查询路段", httpMethod = "POST", notes = "查询路段")
    public CommonResult<String> getRoad(@ApiParam(name = "queryFilter", value = "查询信息") @RequestBody QueryFilter queryFilter) throws Exception {

      return   new CommonResult<String>(this.baseDataStatisticsManager.getRoad(queryFilter));
    }

    @RequestMapping(value = "/getRoadsideFacilities", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "查询沿线设施", httpMethod = "POST", notes = "查询沿线设施")
    public CommonResult<String> getRoadsideFacilities(@ApiParam(name = "queryFilter", value = "查询信息") @RequestBody QueryFilter queryFilter) throws Exception {

        return   new CommonResult<String>(this.baseDataStatisticsManager.getRoadsideFacilities(queryFilter));
    }

    @RequestMapping(value = "/getSideSlop", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "查询边坡", httpMethod = "POST", notes = "查询边坡")
    public CommonResult<String> getSideSlop(@ApiParam(name = "queryFilter", value = "查询信息") @RequestBody QueryFilter queryFilter) throws Exception {

        return   new CommonResult<String>(this.baseDataStatisticsManager.getSideSlop(queryFilter));
    }

    @RequestMapping(value = "/getBridgeInformation", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "查询桥梁", httpMethod = "POST", notes = "查询桥梁")
    public CommonResult<String> getBridgeInformation(@ApiParam(name = "queryFilter", value = "查询信息") @RequestBody QueryFilter queryFilter) throws Exception {

        return   new CommonResult<String>(this.baseDataStatisticsManager.getBridgeInformation(queryFilter));
    }

    @RequestMapping(value = "/getTunnelInformation", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "查询隧道", httpMethod = "POST", notes = "查询隧道")
    public CommonResult<String> getTunnelInformation(@ApiParam(name = "queryFilter", value = "查询信息") @RequestBody QueryFilter queryFilter) throws Exception {

        return new CommonResult<String>(this.baseDataStatisticsManager.getTunnelInformation(queryFilter));
    }

    @RequestMapping(value = "/getCulvertInformation", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "查询涵洞", httpMethod = "POST", notes = "查询涵洞")
    public CommonResult<String> getCulvertInformation(@ApiParam(name = "queryFilter", value = "查询信息") @RequestBody QueryFilter queryFilter) throws Exception {

        return new CommonResult<String>(this.baseDataStatisticsManager.getCulvertInformation(queryFilter));
    }


    @RequestMapping(value = "/countRoadside", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "沿线设施", httpMethod = "POST", notes = "沿线设施")
    public CommonResult<List<CountRoadsideFacilities> > countRoadside(@ApiParam(name = "baseDataParamVo", value = "查询信息") @RequestBody BaseDataParamVo baseDataParamVo) throws Exception {
        return new CommonResult<List<CountRoadsideFacilities> >(true,"查询沿线设施成功",this.baseDataStatisticsManager.countRoadsideFacilities(baseDataParamVo));
    }

    @RequestMapping(value = "/countVehicle", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "养护车辆统计", httpMethod = "POST", notes = "车辆统计")
    public CommonResult<List<CountVehicleVo> > countVehicle(@ApiParam(name = "queryFilter", value = "查询信息")@RequestBody QueryFilter queryFilter) throws Exception {
        return new CommonResult<List<CountVehicleVo> >(true,"查询沿线设施成功",this.baseDataStatisticsManager.countVehicle(queryFilter));
    }

    @RequestMapping(value = "/countAvgMileage", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "平均里程养护费用", httpMethod = "POST", notes = "平均里程养护费用")
    public CommonResult<List<CountMileageVo>> countAvgMileage(@ApiParam(name = "queryFilter", value = "查询信息")@RequestBody QueryFilter queryFilter) throws Exception {
        return new CommonResult<List<CountMileageVo>>(true,"查询平均里程养护费用成功",this.baseDataStatisticsManager.countAvgMileage(queryFilter));
    }





    @RequestMapping(value = "/countVehicleQuantity", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "养护车辆数量统计", httpMethod = "POST", notes = "养护车辆数量统计")
    public CommonResult<List<VehicleQuantityVo> > countVehicleQuantity () throws Exception {
        return new CommonResult<List<VehicleQuantityVo> >(true,"查询沿线设施成功",this.baseDataStatisticsManager.countVehicleQuantity());
    }


    @RequestMapping(value = "/getPreviewURLs", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取监控点预览取流URL", httpMethod = "POST", notes = "")
    public CommonResult<String> getPreviewURLs(@RequestBody PreviewURLsRequest previewURLsRequest) throws Exception {
        Map map = this.baseDataStatisticsManager.getPreviewURLs(previewURLsRequest);
        return new CommonResult<String>(true,String.valueOf(map.get("msg")), String.valueOf(map.get("data")));
    }



    @RequestMapping(value = "/getCameras", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取监控点资源", httpMethod = "POST", notes = "")
    public CommonResult<String> getCameras(@RequestBody CamerasRequest camerasRequest) throws Exception {
        this.baseDataStatisticsManager.getCameras(camerasRequest);
        return new CommonResult<String>(true,"完成");
    }


}
