package com.artfess.yhxt.specialproject.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.specialproject.dao.BizMigrantWorkersSalaryDao;
import com.artfess.yhxt.specialproject.manager.BizMigrantWorkersSalaryManager;
import com.artfess.yhxt.specialproject.model.BizMigrantWorkersSalary;
import com.artfess.yhxt.specialproject.model.BizMigrantWorkersSalary;
import com.artfess.yhxt.specialproject.model.BizMigrantWorkersSalary;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;

/**
 * 民工工资发放情况表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-13
 */
@Service
public class BizMigrantWorkersSalaryManagerImpl extends BaseManagerImpl<BizMigrantWorkersSalaryDao, BizMigrantWorkersSalary> implements BizMigrantWorkersSalaryManager {

    @Override
    public PageList<BizMigrantWorkersSalary> queryBizMigrantWorkersSalary(QueryFilter<BizMigrantWorkersSalary> queryFilter) {
        IPage<BizMigrantWorkersSalary> result = baseMapper.queryBizMigrantWorkersSalary(convert2IPage(queryFilter.getPageBean()),convert2Wrapper(queryFilter,currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public BizMigrantWorkersSalary getBizMigrantWorkersSalaryById(String id) {
        BizMigrantWorkersSalary bizMigrantWorkersSalary = baseMapper.selectById(id);
        return bizMigrantWorkersSalary;
    }
}
