package com.artfess.yhxt.disease.dao;

import com.artfess.yhxt.disease.model.Disease;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.HashMap;
import java.util.Map;

/**
 * 病害管理表 Mapper 接口
 *
 * @author xzh
 * @company 阿特菲斯信息技术有限公司
 * @since 2021-08-09
 */
public interface DiseaseDao extends BaseMapper<Disease> {

    IPage<Disease> getDisease(IPage<Disease> convert2IPage,
                              @Param("map") Map<String, Object> params,
                              @Param(Constants.WRAPPER) Wrapper<Disease> convert2Wrapper);

    //桥梁病害
    IPage<Disease> getJsonDiseaseOftenCheck(IPage<Disease> convert2IPage, @Param("map") Map<String, Object> params,
                                            @Param(Constants.WRAPPER) Wrapper<Disease> convert2Wrapper);

    IPage<Disease> getJsonDiseaseRegularCheck(IPage<Disease> convert2IPage, @Param("map") Map<String, Object> params,

                                              @Param(Constants.WRAPPER) Wrapper<Disease> convert2Wrapper);

    //涵洞
    IPage<Disease> getCulvertDiseaseOftenCheck(IPage<Disease> convert2IPage, @Param("map") Map<String, Object> params,
                                               @Param(Constants.WRAPPER) Wrapper<Disease> convert2Wrapper);

    IPage<Disease> getCulvertDiseaseRegularCheck(IPage<Disease> convert2IPage, @Param("map") Map<String, Object> params,
                                                 @Param(Constants.WRAPPER) Wrapper<Disease> convert2Wrapper);

    //隧道
    IPage<Disease> getTunnelDiseaseOftenCheck(IPage<Disease> convert2IPage, @Param("map") Map<String, Object> params,
                                              @Param(Constants.WRAPPER) Wrapper<Disease> convert2Wrapper);

    IPage<Disease> getTunnelDiseaseRegularCheck(IPage<Disease> convert2IPage, @Param("map") Map<String, Object> params,
                                                @Param(Constants.WRAPPER) Wrapper<Disease> convert2Wrapper);

    //边坡
    IPage<Disease> getSideDiseaseOftenCheck(IPage<Disease> convert2IPage, @Param("map") Map<String, Object> params,
                                            @Param(Constants.WRAPPER) Wrapper<Disease> convert2Wrapper);

    IPage<Disease> getSideDiseaseRegularCheck(IPage<Disease> convert2IPage, @Param("map") Map<String, Object> params,
                                              @Param(Constants.WRAPPER) Wrapper<Disease> convert2Wrapper);

    //查询配置的病害超时日期
    String diseaseTimeDays();
}
