package com.artfess.yhxt.contract.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.Date;

/**
 * @author zhx
 * @create 2022/6/7
 */
@Data
@ApiModel(value = "WorkOrderParam vo对象", description = "工单导出条件")
public class WorkOrderParamVo {
    @ApiModelProperty(value = "开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startTime;


    @ApiModelProperty(value = "结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endTime;

    @ApiModelProperty(value = "路段ID")
    private String roadSegmentId;

    @ApiModelProperty(value = "养护合同ID")
    @NotBlank(message = "选择对应的合同")
    private String contractId;




}
