package com.artfess.yhxt.contract.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;

@Data
public class OrderSpecialCashVo {


    @ApiModelProperty("公司")
    @Excel(name ="公司",width = 20)
    private String companyName;


    @ApiModelProperty("路段名称")
    @Excel(name ="路段名称",width = 20)
    private String roadName;

    @ApiModelProperty("项目名")
    @Excel(name ="项目名",width = 20)
    private String projectName;

    @ApiModelProperty(value = "项目年份")
    private String projectYear;

    @ApiModelProperty("年度预算金额")
    @Excel(name ="年度预算金额",width = 20)
    private BigDecimal annualBudgetCash;

    @ApiModelProperty("合同金额")
    @Excel(name ="合同金额",width = 20)
    private BigDecimal contractCash;

    @ApiModelProperty(value = "工程进度")
    @Excel(name ="工程进度",width = 20)
    private String workProgress;


    @ApiModelProperty("计量支付（百分比）")
    @Excel(name ="计量支付（百分比）",width = 20)
    private String percentageMeasurement;

    @ApiModelProperty(value = "施工地点")
    @Excel(name ="施工地点",width = 20)
    private String constructLocation;


    @ApiModelProperty(value = "施工类型")
    @Excel(name ="施工类型",width = 20)
    private String constructType;


    @ApiModelProperty(value = "开工时间")
    @Excel(name ="开工时间",width = 20)
    private String startTime;

    @ApiModelProperty(value = "完工时间")
    @Excel(name ="完工时间",width = 20)
    private String deliverTime;



    @ApiModelProperty(value = "项目发包")
    @Excel(name ="项目发包",width = 20)
    private String projectContractAwarding;

    @ApiModelProperty(value = "施工单位")
    @Excel(name ="施工单位",width = 20)
    private String constructUnit;

    @ApiModelProperty(value = "项目负责人")
    @Excel(name ="项目负责人",width = 20)
    private String constructUnitPersonLiable;


    @ApiModelProperty(value = "联系电话")
    @Excel(name ="联系电话",width = 20)
    private String constructUnitPersonTel;


}
