package com.artfess.yhxt.contract.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.context.BaseContext;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.*;
import com.artfess.yhxt.basedata.model.SideSlopeInformation;
import com.artfess.yhxt.check.regular.model.BridgeOftenCheck;
import com.artfess.yhxt.contract.vo.ContractVo;
import com.artfess.yhxt.statistics.vo.Org4ContractVO;
import com.artfess.yhxt.statistics.vo.Org4ProjectVO;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.contract.model.Contract;
import com.artfess.yhxt.contract.manager.ContractManager;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

/**
 * 合同表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 超级管理员
 * @since 2021-08-06
 */
@RestController
@RequestMapping("/contract/v1/")
@Api(tags = "合同接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class ContractController extends BaseController<ContractManager, Contract> {

    @Resource
    private BaseContext baseContext;
    @Resource
    PermissionUtils permissionUtils;

    @RequestMapping(value = "getContractVo", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取日常养护合同统计", httpMethod = "POST", notes = "获取日常养护合同统计")
    public List<Org4ContractVO> getContractVo(String year) throws Exception {
        return baseService.getContractCount(year);
    }

    @RequestMapping(value="getJson",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "分页查询合同表",httpMethod = "POST")
    public PageList<Contract> getJson(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<Contract> queryFilter) {
        queryFilter.addFilter("IS_DELE_", "0", QueryOP.EQUAL);
        if (StringUtils.isNotEmpty(baseContext.getCurrentOrgId()) ){
            //queryFilter.addFilter("create_org_id_", String.join("','", baseContext.getCurrentOrgId()), QueryOP.IN, FieldRelation.AND);
//            queryFilter.addFilter("COMPANY_ID_", String.join("','", baseContext.getCurrentOrgId()), QueryOP.IN, FieldRelation.AND);
            permissionUtils.addPermission(queryFilter);
        }
        List<QueryField> querys = queryFilter.getQuerys();
        for (QueryField query : querys) {
            if(query.getProperty().equals("contractDateLimit")){
                query.setProperty("contract_date_limit_");
            }
        }

        return baseService.queryContract(queryFilter);
    }

    @GetMapping(value="get/{id}")
    @ApiOperation(value="根据ID查询合同信息",httpMethod = "GET",notes = "根据ID查询合同信息")
    public ContractVo get(@ApiParam(name="id",value="业务对象主键", required = true)@PathVariable String id) throws Exception{
        return baseService.getContractById(id);
    }

    @RequestMapping(value = "/updateContract", method = RequestMethod.DELETE, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "逻辑删除合同信息", httpMethod = "POST", notes = "逻辑删除合同信息")
    public CommonResult<String> updateContract(@ApiParam(name = "ids", value = "可视化分类ID集合以，隔开", required = true)
                                             @RequestParam(value = "ids", required = true) String ids) throws Exception {
        if (StringUtils.isNotBlank(ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<Contract> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_", idsList);
            updateWrapper.set("is_dele_", "1");
            baseService.update(null, updateWrapper);
        }
        return new CommonResult<>(true, "删除成功");
    }


    @RequestMapping(value = "/save", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存合同信息", httpMethod = "POST", notes = "保存合同信息")
    public CommonResult<String> save(@ApiParam(name = "vo", value = "合同对象") @RequestBody ContractVo vo) throws Exception {
        //this.baseService.checkUniqueNumber(vo.getContract());
        String id = this.baseService.saveContractVo(vo);
        return new CommonResult<>(true, "保存成功",id);
    }

    @RequestMapping(value = "/update", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "修改合同信息", httpMethod = "POST", notes = "修改合同信息")
    public CommonResult<String> update(@ApiParam(name = "vo", value = "合同对象") @RequestBody ContractVo vo) throws Exception {
        this.baseService.checkUniqueNumber(vo.getContract());
        this.baseService.updateContractVo(vo);
        return new CommonResult<>(true, "修改成功");
    }

    @PostMapping("/minioDrawingUpload")
    @ApiOperation(value = "合同文件上传接口")
    public CommonResult<String> minioContractUpload(MultipartFile file,
                                                   @ApiParam(name = "sourceId", value = "资源Id", required = true)
                                                   @RequestParam(value = "sourceId", required = true)String sourceId) {

        return new CommonResult<>(this.baseService.minioContractUpload(file,sourceId));
    }

    @RequestMapping("/downloadContractUpload")
    @ApiOperation(value = "合同文件下载接口",httpMethod = "GET", notes = "合同文件下载接口")
    public void downloadContractUpload( @ApiParam(name = "ids", value = "附件ID集合以，隔开")
                                                        @RequestParam(value = "ids", required = true) String ids,
                                        HttpServletResponse response) throws IOException {
        this.baseService.downloadContractUpload(ids,response);

    }


    @DeleteMapping(value = "/removesContract")
    @ApiOperation(value = "删除定期检查附件", httpMethod = "DELETE", notes = "删除病害图片")
    public CommonResult<String> minioContractDel(@ApiParam(name = "ids", value = "多个主键之间用逗号分隔", required = true) @RequestParam String ids) throws Exception {
        baseService.minioContractDel(Arrays.asList(ids));
        return new CommonResult<String>(true, "删除成功");
    }


    @RequestMapping(value = "/saveVo", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存合同信息、附件", httpMethod = "POST", notes = "保存合同信息、附件")
    public CommonResult<String> saveVo(@ApiParam(name = "vo", value = "合同对象") @RequestBody ContractVo vo) throws Exception {
//        this.baseService.checkUniqueNumber(vo.getContract());
        String id ="";
        Contract contract = vo.getContract();
        if (StringUtils.isEmpty(contract.getId())){
            id = this.baseService.saveContractVo(vo);
        }else {
            id = this.baseService.updateContractVo(vo);
        }
        return new CommonResult<>(true, "保存成功",id);
    }
}
