package com.artfess.yhxt.check.regular.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 隧道定期检查表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-17
 */
@ApiModel(value="TunnelRegularCheck对象", description="隧道定期检查表")
@TableName("biz_tunnel_regular_check")
public class TunnelRegularCheck extends BizModel<TunnelRegularCheck> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "隧道id")
    @TableField("TUNNEL_ID_")
    private String tunnelId;

    @ApiModelProperty(value = "隧道名称")
    @TableField("TUNNEL_NAME_")
    private String tunnelName;

    @ApiModelProperty(value = "上次检查日期")
    @TableField("LAST_CHECK_DATE_")
    private LocalDate lastCheckDate;

    @ApiModelProperty(value = "检查日期")
    @TableField("CHECK_DATE_")
    private LocalDate checkDate;

    @ApiModelProperty(value = "检查人")
    @TableField("RUMMAGER_")
    private String rummager;

    @ApiModelProperty(value = "记录人")
    @TableField("NOTE_TAKER_")
    private String noteTaker;

    @ApiModelProperty(value = "结构技术状况评分")
    @TableField("SKILL_SCORE_")
    private String skillScore;

    @ApiModelProperty(value = "处置情况")
    @TableField("PROCESSING_")
    private String processing;

    @ApiModelProperty(value = "附件地址")
    @TableField("URL_")
    private String url;

    @ApiModelProperty(value = "结构技术状况评分值")
    @TableField("SKILL_SCORE_VALUE_")
    private String skillScoreValue;

    @ApiModelProperty(value = "检查明细")
    @TableField("CHCEK_DETAIL_JSON_")
    private String chcekDetailJson;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "天气")
    @TableField("WEATHER_")
    private String weather;

    public String getWeather() {
        return weather;
    }

    public void setWeather(String weather) {
        this.weather = weather;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getTunnelId() {
        return tunnelId;
    }

    public void setTunnelId(String tunnelId) {
        this.tunnelId = tunnelId;
    }
    public String getTunnelName() {
        return tunnelName;
    }

    public void setTunnelName(String tunnelName) {
        this.tunnelName = tunnelName;
    }
    public LocalDate getLastCheckDate() {
        return lastCheckDate;
    }

    public void setLastCheckDate(LocalDate lastCheckDate) {
        this.lastCheckDate = lastCheckDate;
    }
    public LocalDate getCheckDate() {
        return checkDate;
    }

    public void setCheckDate(LocalDate checkDate) {
        this.checkDate = checkDate;
    }
    public String getRummager() {
        return rummager;
    }

    public void setRummager(String rummager) {
        this.rummager = rummager;
    }
    public String getNoteTaker() {
        return noteTaker;
    }

    public void setNoteTaker(String noteTaker) {
        this.noteTaker = noteTaker;
    }
    public String getSkillScore() {
        return skillScore;
    }

    public void setSkillScore(String skillScore) {
        this.skillScore = skillScore;
    }
    public String getProcessing() {
        return processing;
    }

    public void setProcessing(String processing) {
        this.processing = processing;
    }
    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
    public String getSkillScoreValue() {
        return skillScoreValue;
    }

    public void setSkillScoreValue(String skillScoreValue) {
        this.skillScoreValue = skillScoreValue;
    }
    public String getChcekDetailJson() {
        return chcekDetailJson;
    }

    public void setChcekDetailJson(String chcekDetailJson) {
        this.chcekDetailJson = chcekDetailJson;
    }
    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }
    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "TunnelRegularCheck{" +
                "id='" + id + '\'' +
                ", tunnelId='" + tunnelId + '\'' +
                ", tunnelName='" + tunnelName + '\'' +
                ", lastCheckDate=" + lastCheckDate +
                ", checkDate=" + checkDate +
                ", rummager='" + rummager + '\'' +
                ", noteTaker='" + noteTaker + '\'' +
                ", skillScore='" + skillScore + '\'' +
                ", processing='" + processing + '\'' +
                ", url='" + url + '\'' +
                ", skillScoreValue='" + skillScoreValue + '\'' +
                ", chcekDetailJson='" + chcekDetailJson + '\'' +
                ", companyId='" + companyId + '\'' +
                ", companyName='" + companyName + '\'' +
                ", weather='" + weather + '\'' +
                '}';
    }
}
