package com.artfess.yhxt.check.regular.manager.impl;

import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.poi.style.Align;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.model.SysDictionaryDetail;
import com.artfess.yhxt.basedata.manager.*;
import com.artfess.yhxt.basedata.model.*;
import com.artfess.yhxt.basedata.vo.*;
import com.artfess.yhxt.check.detail.manager.BridgeOftenCheckDetailManager;
import com.artfess.yhxt.check.detail.manager.TunnelOftenCheckDetailManager;
import com.artfess.yhxt.check.detail.model.BridgeOftenCheckDetail;
import com.artfess.yhxt.check.detail.model.TunnelOftenCheckDetail;
import com.artfess.yhxt.check.regular.manager.BridgeOftenCheckManager;
import com.artfess.yhxt.check.regular.manager.CheckExportManager;
import com.artfess.yhxt.check.regular.manager.TunnelOftenCheckManager;
import com.artfess.yhxt.check.regular.model.BridgeOftenCheck;
import com.artfess.yhxt.check.regular.model.TunnelOftenCheck;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.jsonwebtoken.lang.Assert;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.util.Zip4jConstants;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.*;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author zhx
 * @create 2022/2/23
 */
@Service
public class CheckExportManagerImpl implements CheckExportManager {



    @Resource
    private BridgeInformationManager bridgeInformationManager;
    @Resource
    private TunnelInformationManager tunnelInformationManager;
    @Resource
    private BizCulvertInformationManager culvertInformationManager;
    @Resource
    private SideSlopeInformationManager sideSlopeInformationManager;


    @Override
    public HSSFWorkbook exportBridgeOftenList(String ids, HttpServletResponse response) {
        try {
            QueryFilter<BridgeInformation> queryFilter = (QueryFilter<BridgeInformation>) QueryFilter.build().withPage(new PageBean(1, PageBean.WITHOUT_PAGE));
            PageList<BridgeCheckVo> bridgeCheckPageList = bridgeInformationManager.queryBridge(queryFilter);
            List<BridgeCheckVo> rows = bridgeCheckPageList.getRows();
            HashMap<String, String> hashMap = new HashMap<>();
            hashMap.put("number", "桥梁编码");
            hashMap.put("roadSegmentName", "所属路段");
            hashMap.put("name", "桥梁名称");
            hashMap.put("typeValue", "桥梁类型");
            hashMap.put("categoryValue", "桥梁类别");
            hashMap.put("centPeg", "中心桩号");
            hashMap.put("directionValue", "方向");
            hashMap.put("officeName", "管养单位");
            hashMap.put("companyName", "归属公司");
            hashMap.put("spanCombo", "跨径组合");
            hashMap.put("checkDate", "最后检查时间");
            hashMap.put("evaluateValue", "总体评价");
            if (StringUtils.isNotEmpty(ids)) {
                List<BridgeCheckVo> vos = rows.stream().filter(s -> Arrays.asList(ids.split(",")).contains(s.getId())).collect(Collectors.toList());

                List<HashMap<String, Object>> collect = vos.stream().map(s -> {
                    HashMap<String, Object> map = new HashMap<>();
                    map.put("number", s.getNumber());
                    map.put("roadSegmentName", s.getRoadSegmentName());
                    map.put("name", s.getName());
                    map.put("typeValue", s.getTypeValue());
                    map.put("categoryValue", s.getCategoryValue());
                    if (s.getCentPeg()==0){
                        if (StringUtils.isNotEmpty(s.getStartPegK())){
                            if (s.getStartPegK().contains("+")){
                                map.put("centPeg",s.getStartPegK().substring(0,s.getStartPegK().indexOf("+")));
                            }
                        }
                    }else {
                        map.put("centPeg", s.getCentPeg());
                    }

                    map.put("directionValue", s.getDirectionValue());
                    map.put("officeName", s.getOfficeName());
                    map.put("companyName", s.getCompanyName());
                    map.put("spanCombo", s.getSpanCombo());
                    map.put("checkDate", s.getCheckDate());
                    map.put("evaluateValue", s.getEvaluateValue());
                    return map;
                }).collect(Collectors.toList());
                return ExcelUtil.exportExcel("桥梁经常检查", 10, hashMap, collect);
            } else {
                List<HashMap<String, Object>> collect = rows.stream().map(s -> {
                    HashMap<String, Object> map = new HashMap<>();
                    map.put("number", s.getNumber());
                    map.put("roadSegmentName", s.getRoadSegmentName());
                    map.put("name", s.getName());
                    map.put("typeValue", s.getTypeValue());
                    map.put("categoryValue", s.getCategoryValue());
                    map.put("centPeg", s.getCentPeg());
                    map.put("directionValue", s.getDirectionValue());
                    map.put("officeName", s.getOfficeName());
                    map.put("companyName", s.getCompanyName());
                    map.put("spanCombo", s.getSpanCombo());
                    map.put("checkDate", s.getCheckDate());
                    map.put("evaluateValue", s.getEvaluateValue());
                    return map;
                }).collect(Collectors.toList());
                return ExcelUtil.exportExcel("桥梁经常检查", 10, hashMap, collect);
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("导出列表失败！");
        }
    }



    @Override
    public HSSFWorkbook exportTunnelOftenList(String ids, HttpServletResponse response) {
        try {
            QueryFilter<TunnelInformation> queryFilter = (QueryFilter<TunnelInformation>) QueryFilter.build().withPage(new PageBean(1, PageBean.WITHOUT_PAGE));
            PageList<TunnelCheckVo> tunnelCheckVoPageList = tunnelInformationManager.queryTunnel(queryFilter);
            List<TunnelCheckVo> rows = tunnelCheckVoPageList.getRows();
            HashMap<String, String> hashMap = new HashMap<>();
            hashMap.put("number", "隧道编码");
            hashMap.put("roadSegmentName", "所属路段");
            hashMap.put("name", "隧道名称");
            hashMap.put("typeValue", "隧道分类");
            hashMap.put("gradeValue", "隧道等级");
            hashMap.put("centPeg", "中心桩号");
            hashMap.put("directionValue", "方向");
            hashMap.put("officeName", "管养单位");
            hashMap.put("companyName", "归属公司");
            hashMap.put("length", "隧道长度");
            hashMap.put("checkDate", "最后检查时间");
            hashMap.put("evaluateValue", "总体评价");
            if (StringUtils.isNotEmpty(ids)) {
                List<HashMap<String, Object>> collect = rows.stream().filter(s -> Arrays.asList(ids.split(",")).contains(s.getId())).map(s -> {
                    HashMap<String, Object> map = new HashMap<>();
                    map.put("number", s.getNumber());
                    map.put("roadSegmentName", s.getRoadSegmentName());
                    map.put("name", s.getName());
                    map.put("typeValue", s.getTypeValue());
                    map.put("gradeValue", s.getGradeValue());
                    map.put("centPeg", s.getCentPeg());
                    map.put("directionValue", s.getDirectionValue());
                    map.put("officeName", s.getOfficeName());
                    map.put("companyName", s.getCompanyName());
                    map.put("length", s.getLength());
                    map.put("checkDate", s.getCheckDate());
                    map.put("evaluateValue", s.getEvaluateValue());
                    return map;
                }).collect(Collectors.toList());
                return ExcelUtil.exportExcel("隧道经常检查", 10, hashMap, collect);
            } else {
                List<HashMap<String, Object>> collect = rows.stream().map(s -> {
                    HashMap<String, Object> map = new HashMap<>();
                    map.put("number", s.getNumber());
                    map.put("roadSegmentName", s.getRoadSegmentName());
                    map.put("name", s.getName());
                    map.put("typeValue", s.getTypeValue());
                    map.put("gradeValue", s.getGradeValue());
                    map.put("centPeg", s.getCentPeg());
                    map.put("directionValue", s.getDirectionValue());
                    map.put("officeName", s.getOfficeName());
                    map.put("companyName", s.getCompanyName());
                    map.put("length", s.getLength());
                    map.put("checkDate", s.getCheckDate());
                    map.put("evaluateValue", s.getEvaluateValue());
                    return map;
                }).collect(Collectors.toList());
                return ExcelUtil.exportExcel("隧道经常检查", 10, hashMap, collect);
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("导出列表失败！");
        }
    }

    @Override
    public HSSFWorkbook exportCulvertOftenList(String ids, HttpServletResponse response) {
        try {
            QueryFilter<BizCulvertInformation> queryFilter = (QueryFilter<BizCulvertInformation>) QueryFilter.build().withPage(new PageBean(1, PageBean.WITHOUT_PAGE));
            PageList<CulvertCheckVo> culvertCheckVoPageList = culvertInformationManager.queryBizCulvert(queryFilter);
            List<CulvertCheckVo> rows = culvertCheckVoPageList.getRows();
            HashMap<String, String> hashMap = new HashMap<>();
            hashMap.put("number", "涵洞编号");
            hashMap.put("centPeg", "中心桩号");
            hashMap.put("rampPeg", "匝道桩号");
            hashMap.put("roadSegmentName", "所属路段");
            hashMap.put("typeValue", "涵洞类型");
            hashMap.put("directionValue", "方向");
            hashMap.put("officeName", "管养单位");
            hashMap.put("companyName", "归属公司");
            hashMap.put("height", "涵洞高度");
            hashMap.put("length", "洞身长度");
            hashMap.put("checkDate", "最后检查时间");
            hashMap.put("evaluateValue", "总体评价");
            if (StringUtils.isNotEmpty(ids)) {
                List<HashMap<String, Object>> collect = rows.stream().filter(s -> Arrays.asList(ids.split(",")).contains(s.getId())).map(s -> {
                    HashMap<String, Object> map = new HashMap<>();
                    map.put("number", s.getNumber());
                    map.put("centPeg", s.getCentPeg());
                    map.put("rampPeg", s.getRampPeg());
                    map.put("roadSegmentName", s.getRoadSegmentName());
                    map.put("typeValue", s.getTypeValue());
                    map.put("directionValue", s.getDirectionValue());
                    map.put("officeName", s.getOfficeName());
                    map.put("companyName", s.getCompanyName());
                    map.put("height", s.getHeight());
                    map.put("length", s.getLength());
                    map.put("checkDate", s.getCheckDate());
                    map.put("evaluateValue", s.getEvaluateValue());
                    return map;
                }).collect(Collectors.toList());
                return ExcelUtil.exportExcel("涵洞经常检查", 10, hashMap, collect);
            } else {
                List<HashMap<String, Object>> collect = rows.stream().map(s -> {
                    HashMap<String, Object> map = new HashMap<>();
                    map.put("number", s.getNumber());
                    map.put("centPeg", s.getCentPeg());
                    map.put("rampPeg", s.getRampPeg());
                    map.put("roadSegmentName", s.getRoadSegmentName());
                    map.put("typeValue", s.getTypeValue());
                    map.put("directionValue", s.getDirectionValue());
                    map.put("officeName", s.getOfficeName());
                    map.put("companyName", s.getCompanyName());
                    map.put("height", s.getHeight());
                    map.put("length", s.getLength());
                    map.put("checkDate", s.getCheckDate());
                    map.put("evaluateValue", s.getEvaluateValue());
                    return map;
                }).collect(Collectors.toList());
                return ExcelUtil.exportExcel("涵洞经常检查", 10, hashMap, collect);
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("导出列表失败！");
        }
    }

    @Override
    public HSSFWorkbook exportSideSlopeOftenList(String ids, HttpServletResponse response) {
        try {
            QueryFilter<SideSlopeInformation> queryFilter = (QueryFilter<SideSlopeInformation>) QueryFilter.build().withPage(new PageBean(1, PageBean.WITHOUT_PAGE));
            PageList<SideSlopCheckVo> sideSlopCheckVoPageList = sideSlopeInformationManager.querySideSlope(queryFilter);
            List<SideSlopCheckVo> rows = sideSlopCheckVoPageList.getRows();
            HashMap<String, String> hashMap = new HashMap<>();
            hashMap.put("number", "边坡编码");
            hashMap.put("roadSegmentName", "所属路段");
            hashMap.put("companyName", "归属公司");
            hashMap.put("officeName", "管养单位");
            hashMap.put("startPeg", "开始桩号");
            hashMap.put("endPeg", "结束桩号");
            hashMap.put("directionValue", "方向");
            hashMap.put("protectMaterial", "防护种类");
            hashMap.put("height", "边坡高度");
            hashMap.put("length", "边坡长度");
            hashMap.put("checkDate", "最后检查时间");
            hashMap.put("evaluateValue", "总体评价");
            hashMap.put("rummager", "检查人");
            hashMap.put("noteTaker", "记录人");
            if (StringUtils.isNotEmpty(ids)) {
                List<HashMap<String, Object>> collect = rows.stream().filter(s -> Arrays.asList(ids.split(",")).contains(s.getId())).map(s -> {
                    HashMap<String, Object> map = new HashMap<>();
                    map.put("number", s.getNumber());
                    map.put("roadSegmentName", s.getRoadSegmentName());
                    map.put("companyName", s.getCompanyName());
                    map.put("officeName", s.getOfficeName());
                    map.put("startPeg", s.getStartPeg());
                    map.put("endPeg", s.getEndPeg());
                    map.put("directionValue", s.getDirectionValue());
                    map.put("protectMaterial", s.getProtectMaterial());
                    map.put("height", s.getHeight());
                    map.put("length", s.getLength());
                    map.put("checkDate", s.getCheckDate());
                    map.put("evaluateValue", s.getEvaluateValue());
                    map.put("rummager", s.getRummager());
                    map.put("noteTaker", s.getNoteTaker());
                    return map;
                }).collect(Collectors.toList());
                return ExcelUtil.exportExcel("边坡经常检查", 10, hashMap, collect);
            } else {
                List<HashMap<String, Object>> collect = rows.stream().map(s -> {
                    HashMap<String, Object> map = new HashMap<>();
                    map.put("number", s.getNumber());
                    map.put("roadSegmentName", s.getRoadSegmentName());
                    map.put("companyName", s.getCompanyName());
                    map.put("officeName", s.getOfficeName());
                    map.put("startPeg", s.getStartPeg());
                    map.put("endPeg", s.getEndPeg());
                    map.put("directionValue", s.getDirectionValue());
                    map.put("protectMaterial", s.getProtectMaterial());
                    map.put("height", s.getHeight());
                    map.put("length", s.getLength());
                    map.put("checkDate", s.getCheckDate());
                    map.put("evaluateValue", s.getEvaluateValue());
                    map.put("rummager", s.getRummager());
                    map.put("noteTaker", s.getNoteTaker());
                    return map;
                }).collect(Collectors.toList());
                return ExcelUtil.exportExcel("边坡经常检查", 10, hashMap, collect);
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("导出列表失败！");
        }

    }

    @Override
    public HSSFWorkbook exportBridgeRegularList(String ids, HttpServletResponse response) {
        try {
            QueryFilter<BridgeInformation> queryFilter = (QueryFilter<BridgeInformation>) QueryFilter.build().withPage(new PageBean(1, PageBean.WITHOUT_PAGE));
            PageList<BridgeRegularVo> bridgeCheckPageList = bridgeInformationManager.queryBridgeRegularCheckVo(queryFilter);
            List<BridgeRegularVo> rows = bridgeCheckPageList.getRows();
            HashMap<String, String> hashMap = new HashMap<>();
            hashMap.put("number", "桥梁编码");
            hashMap.put("roadSegmentName", "所属路段");
            hashMap.put("name", "桥梁名称");
            hashMap.put("typeValue", "桥梁类型");
            hashMap.put("categoryValue", "桥梁类别");
            hashMap.put("centPeg", "中心桩号");
            hashMap.put("directionValue", "方向");
            hashMap.put("officeName", "管养单位");
            hashMap.put("companyName", "归属公司");
            hashMap.put("spanCombo", "跨径组合");
            hashMap.put("checkDate", "最后检查时间");
            hashMap.put("overallRatingValue", "总体状况评定等级");
            if (StringUtils.isNotEmpty(ids)) {
                List<HashMap<String, Object>> collect = rows.stream().filter(s -> Arrays.asList(ids.split(",")).contains(s.getId())).map(s -> {
                    HashMap<String, Object> map = new HashMap<>();
                    map.put("number", s.getNumber());
                    map.put("roadSegmentName", s.getRoadSegmentName());
                    map.put("name", s.getName());
                    map.put("typeValue", s.getTypeValue());
                    map.put("categoryValue", s.getCategoryValue());
                    map.put("centPeg", s.getCentPeg());
                    map.put("directionValue", s.getDirectionValue());
                    map.put("officeName", s.getOfficeName());
                    map.put("companyName", s.getCompanyName());
                    map.put("spanCombo", s.getSpanCombo());
                    map.put("checkDate", s.getCheckDate());
                    map.put("overallRatingValue", s.getOverallRatingValue());
                    return map;
                }).collect(Collectors.toList());
                return ExcelUtil.exportExcel("桥梁定期检查", 10, hashMap, collect);
            } else {
                List<HashMap<String, Object>> collect = rows.stream().map(s -> {
                    HashMap<String, Object> map = new HashMap<>();
                    map.put("number", s.getNumber());
                    map.put("roadSegmentName", s.getRoadSegmentName());
                    map.put("name", s.getName());
                    map.put("typeValue", s.getTypeValue());
                    map.put("categoryValue", s.getCategoryValue());
                    map.put("centPeg", s.getCentPeg());
                    map.put("directionValue", s.getDirectionValue());
                    map.put("officeName", s.getOfficeName());
                    map.put("companyName", s.getCompanyName());
                    map.put("spanCombo", s.getSpanCombo());
                    map.put("checkDate", s.getCheckDate());
                    map.put("overallRatingValue", s.getOverallRatingValue());
                    return map;
                }).collect(Collectors.toList());
                return ExcelUtil.exportExcel("桥梁定期检查", 10, hashMap, collect);
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("导出列表失败！");
        }
    }

    @Override
    public HSSFWorkbook exportTunnelRegularList(String ids, HttpServletResponse response) {
        try {
            QueryFilter<TunnelInformation> queryFilter = (QueryFilter<TunnelInformation>) QueryFilter.build().withPage(new PageBean(1, PageBean.WITHOUT_PAGE));
            PageList<TunnelRegularVo> tunnelCheckVoPageList = tunnelInformationManager.queryTunnelRegular(queryFilter);
            List<TunnelRegularVo> rows = tunnelCheckVoPageList.getRows();
            HashMap<String, String> hashMap = new HashMap<>();
            hashMap.put("number", "隧道编码");
            hashMap.put("roadSegmentName", "所属路段");
            hashMap.put("name", "隧道名称");
            hashMap.put("typeValue", "隧道分类");
            hashMap.put("gradeValue", "隧道等级");
            hashMap.put("centPeg", "中心桩号");
            hashMap.put("directionValue", "方向");
            hashMap.put("officeName", "管养单位");
            hashMap.put("companyName", "归属公司");
            hashMap.put("length", "隧道长度");
            hashMap.put("checkDate", "最后检查时间");
            hashMap.put("skillScoreValue", "结构技术状况评分");
            if (StringUtils.isNotEmpty(ids)) {
                List<HashMap<String, Object>> collect = rows.stream().filter(s -> Arrays.asList(ids.split(",")).contains(s.getId())).map(s -> {
                    HashMap<String, Object> map = new HashMap<>();
                    map.put("number", s.getNumber());
                    map.put("roadSegmentName", s.getRoadSegmentName());
                    map.put("name", s.getName());
                    map.put("typeValue", s.getTypeValue());
                    map.put("gradeValue", s.getGradeValue());
                    map.put("centPeg", s.getCentPeg());
                    map.put("directionValue", s.getDirectionValue());
                    map.put("officeName", s.getOfficeName());
                    map.put("companyName", s.getCompanyName());
                    map.put("length", s.getLength());
                    map.put("checkDate", s.getCheckDate());
                    map.put("skillScoreValue", s.getSkillScoreValue());
                    return map;
                }).collect(Collectors.toList());
                return ExcelUtil.exportExcel("隧道经常检查", 10, hashMap, collect);
            } else {
                List<HashMap<String, Object>> collect = rows.stream().map(s -> {
                    HashMap<String, Object> map = new HashMap<>();
                    map.put("number", s.getNumber());
                    map.put("roadSegmentName", s.getRoadSegmentName());
                    map.put("name", s.getName());
                    map.put("typeValue", s.getTypeValue());
                    map.put("gradeValue", s.getGradeValue());
                    map.put("centPeg", s.getCentPeg());
                    map.put("directionValue", s.getDirectionValue());
                    map.put("officeName", s.getOfficeName());
                    map.put("companyName", s.getCompanyName());
                    map.put("length", s.getLength());
                    map.put("checkDate", s.getCheckDate());
                    map.put("skillScoreValue", s.getSkillScoreValue());
                    return map;
                }).collect(Collectors.toList());
                return ExcelUtil.exportExcel("隧道经常检查", 10, hashMap, collect);
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("导出列表失败！");
        }
    }

    @Override
    public HSSFWorkbook exportCulvertRegularList(String ids, HttpServletResponse response) {
        try {
            QueryFilter<BizCulvertInformation> queryFilter = (QueryFilter<BizCulvertInformation>) QueryFilter.build().withPage(new PageBean(1, PageBean.WITHOUT_PAGE));
            PageList<CulvertRegularVo> culvertCheckVoPageList = culvertInformationManager.queryCulvertRegular(queryFilter);
            List<CulvertRegularVo> rows = culvertCheckVoPageList.getRows();
            HashMap<String, String> hashMap = new HashMap<>();
            hashMap.put("number", "涵洞编号");
            hashMap.put("centPeg", "中心桩号");
            hashMap.put("rampPeg", "匝道桩号");
            hashMap.put("roadSegmentName", "所属路段");
            hashMap.put("typeValue", "涵洞类型");
            hashMap.put("directionValue", "方向");
            hashMap.put("officeName", "管养单位");
            hashMap.put("companyName", "归属公司");
            hashMap.put("height", "涵洞高度");
            hashMap.put("length", "洞身长度");
            hashMap.put("checkDate", "最后检查时间");
            hashMap.put("evaluateValue", "总体评价");
            if (StringUtils.isNotEmpty(ids)) {
                List<HashMap<String, Object>> collect = rows.stream().filter(s -> Arrays.asList(ids.split(",")).contains(s.getId())).map(s -> {
                    HashMap<String, Object> map = new HashMap<>();
                    map.put("number", s.getNumber());
                    map.put("centPeg", s.getCentPeg());
                    map.put("rampPeg", s.getRampPeg());
                    map.put("roadSegmentName", s.getRoadSegmentName());
                    map.put("typeValue", s.getTypeValue());
                    map.put("directionValue", s.getDirectionValue());
                    map.put("officeName", s.getOfficeName());
                    map.put("companyName", s.getCompanyName());
                    map.put("height", s.getHeight());
                    map.put("length", s.getLength());
                    map.put("checkDate", s.getCheckDate());
                    map.put("evaluateValue", s.getEvaluateValue());
                    return map;
                }).collect(Collectors.toList());
                return ExcelUtil.exportExcel("涵洞定期检查", 10, hashMap, collect);
            } else {
                List<HashMap<String, Object>> collect = rows.stream().map(s -> {
                    HashMap<String, Object> map = new HashMap<>();
                    map.put("number", s.getNumber());
                    map.put("centPeg", s.getCentPeg());
                    map.put("rampPeg", s.getRampPeg());
                    map.put("roadSegmentName", s.getRoadSegmentName());
                    map.put("typeValue", s.getTypeValue());
                    map.put("directionValue", s.getDirectionValue());
                    map.put("officeName", s.getOfficeName());
                    map.put("companyName", s.getCompanyName());
                    map.put("height", s.getHeight());
                    map.put("length", s.getLength());
                    map.put("checkDate", s.getCheckDate());
                    map.put("evaluateValue", s.getEvaluateValue());
                    return map;
                }).collect(Collectors.toList());
                return ExcelUtil.exportExcel("涵洞定期检查", 10, hashMap, collect);
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("导出列表失败！");
        }
    }

    @Override
    public HSSFWorkbook exportSideSlopeRegularList(String ids, HttpServletResponse response) {
        try {
            QueryFilter<SideSlopeInformation> queryFilter = (QueryFilter<SideSlopeInformation>) QueryFilter.build().withPage(new PageBean(1, PageBean.WITHOUT_PAGE));
            PageList<SideSlopeRegularVo> sideSlopCheckVoPageList = sideSlopeInformationManager.queryRegularSideSlope(queryFilter);
            List<SideSlopeRegularVo> rows = sideSlopCheckVoPageList.getRows();
            HashMap<String, String> hashMap = new HashMap<>();
            hashMap.put("number", "边坡编码");
            hashMap.put("roadSegmentName", "所属路段");
            hashMap.put("companyName", "归属公司");
            hashMap.put("officeName", "管养单位");
            hashMap.put("startPeg", "开始桩号");
            hashMap.put("endPeg", "结束桩号");
            hashMap.put("directionValue", "方向");
            hashMap.put("protectMaterial", "防护种类");
            hashMap.put("height", "边坡高度");
            hashMap.put("length", "边坡长度");
            hashMap.put("checkDate", "最后检查时间");
            hashMap.put("overallRatingValue", "总体状况评定等级");
            if (StringUtils.isNotEmpty(ids)) {
                List<HashMap<String, Object>> collect = rows.stream().filter(s -> Arrays.asList(ids.split(",")).contains(s.getId())).map(s -> {
                    HashMap<String, Object> map = new HashMap<>();
                    map.put("number", s.getNumber());
                    map.put("roadSegmentName", s.getRoadSegmentName());
                    map.put("companyName", s.getCompanyName());
                    map.put("officeName", s.getOfficeName());
                    map.put("startPeg", s.getStartPeg());
                    map.put("endPeg", s.getEndPeg());
                    map.put("directionValue", s.getDirectionValue());
                    map.put("protectMaterial", s.getProtectMaterial());
                    map.put("height", s.getHeight());
                    map.put("length", s.getLength());
                    map.put("checkDate", s.getCheckDate());
                    map.put("overallRatingValue", s.getOverallRatingValue());

                    return map;
                }).collect(Collectors.toList());
                return ExcelUtil.exportExcel("边坡定期检查", 10, hashMap, collect);
            } else {
                List<HashMap<String, Object>> collect = rows.stream().map(s -> {
                    HashMap<String, Object> map = new HashMap<>();
                    map.put("number", s.getNumber());
                    map.put("roadSegmentName", s.getRoadSegmentName());
                    map.put("companyName", s.getCompanyName());
                    map.put("officeName", s.getOfficeName());
                    map.put("startPeg", s.getStartPeg());
                    map.put("endPeg", s.getEndPeg());
                    map.put("directionValue", s.getDirectionValue());
                    map.put("protectMaterial", s.getProtectMaterial());
                    map.put("height", s.getHeight());
                    map.put("length", s.getLength());
                    map.put("checkDate", s.getCheckDate());
                    map.put("overallRatingValue", s.getOverallRatingValue());
                    return map;
                }).collect(Collectors.toList());
                return ExcelUtil.exportExcel("边坡定期检查", 10, hashMap, collect);
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("导出列表失败！");
        }
    }


}
