package com.artfess.yhxt.assessment.model;

import com.artfess.base.entity.BaseModel;

import java.time.LocalDate;
import java.time.LocalDateTime;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 养护考核表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2021-11-03
 */
@ApiModel(value="CuringAssessment对象", description="养护考核表")
@TableName("BIZ_CURING_ASSESSMENT")
public class CuringAssessment extends BizModel<CuringAssessment> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "路段ID，隐藏字段，选择路段时填入")
    @TableField("ROAD_ID_")
    private String roadId;

    @ApiModelProperty(value = "路段")
    @TableField("ROAD_NAME_")
    private String roadName;

    @ApiModelProperty(value = "路段所属公司ID，隐藏字段，选择路段时填入")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "路段所属公司名称，隐藏字段，")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "合同ID")
    @TableField("ITEM_ID_")
    private String itemId;

    @ApiModelProperty(value = "合同名称")
    @TableField("ITEM_NAME_")
    private String itemName;

    @ApiModelProperty(value = "合同编号")
    @TableField("ITEM_NOMBER_")
    private String itemNomber;

    @ApiModelProperty(value = "考核季度，1：第一季度，2：第二季度，3：第三季度，4：第四季度，5：自定义时间")
    @TableField("ASSESSMENT_QUARTER_")
    private Integer assessmentQuarter;

    @ApiModelProperty(value = "考核开始日期，如果选择的是季度，就适合季度开始日期，如果选择的是自定义时间，就是传入的开始日期")
    @TableField("START_DATE_")
    private LocalDate startDate;

    @ApiModelProperty(value = "考核结束日期，如果选择的是季度，就适合季度结束日期，如果选择的是自定义时间，就是传入的结束日期")
    @TableField("END_DATE_")
    private LocalDate endDate;

    @ApiModelProperty(value = "得分，根据明细表合计得分")
    @TableField("SCORE_")
    private String score;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getRoadId() {
        return roadId;
    }

    public void setRoadId(String roadId) {
        this.roadId = roadId;
    }
    public String getRoadName() {
        return roadName;
    }

    public void setRoadName(String roadName) {
        this.roadName = roadName;
    }
    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }
    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }
    public String getItemId() {
        return itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }
    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }
    public String getItemNomber() {
        return itemNomber;
    }

    public void setItemNomber(String itemNomber) {
        this.itemNomber = itemNomber;
    }
    public Integer getAssessmentQuarter() {
        return assessmentQuarter;
    }

    public void setAssessmentQuarter(Integer assessmentQuarter) {
        this.assessmentQuarter = assessmentQuarter;
    }
    public LocalDate getStartDate() {
        return startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }
    public LocalDate getEndDate() {
        return endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }
    public String getScore() {
        return score;
    }

    public void setScore(String score) {
        this.score = score;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Override
    protected Serializable pkVal() {
        return null;
    }

    @Override
    public String toString() {
        return "BizCuringAssessment{" +
            "id=" + id +
            ", roadId=" + roadId +
            ", roadName=" + roadName +
            ", companyId=" + companyId +
            ", companyName=" + companyName +
            ", itemId=" + itemId +
            ", itemName=" + itemName +
            ", itemNomber=" + itemNomber +
            ", assessmentQuarter=" + assessmentQuarter +
            ", startDate=" + startDate +
            ", endDate=" + endDate +
            ", score=" + score +
            ", remarks=" + remarks +
        "}";
    }
}
