package com.artfess.yhxt.statistics.vo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author zhx
 * @create 2022/4/1
 */
@Data
@ApiModel(value = "VehicleQuantityVo 对象", description = "养护车数量")
public class VehicleQuantityVo {

    @ApiModelProperty(value = "路段id(关联路段表ID)")
    @TableField("ROAD_SEGMENT_ID_")
    private String roadSegmentId;

    @ApiModelProperty(value = "路段名称")
    @TableField("ROAD_SEGMENT_NAME_")
    private String roadSegmentName;
    @ApiModelProperty(value = "道路清洁车数量")
    @TableField("ROAD_CLEANING_VEHICLE_")
    private String roadCleaningVehicle;


    @ApiModelProperty(value = "护栏清洗车数量")
    @TableField("GUARDRAIL_CLEANING_VEHICLE_")
    private String guardrailCleaningVehicle;
    @ApiModelProperty(value = "高空作业车数量")
    @TableField("AERIAL_WORK_TRUCK_VEHICLE_")
    private String aerialWorkTruckVehicle;

    @ApiModelProperty(value = "洒水车数量")
    @TableField("WATERING_VEHICLE_")
    private String wateringVehicle;

    @ApiModelProperty(value = "路面冲洗车")
    @TableField("ROAD_WASHING_VEHICLE_")
    private String roadWashingVehicle;

    @ApiModelProperty(value = "随车起重机")
    @TableField("TRUCK_MOUNTED_CRANE_")
    private String truckMountedCrane;

    @ApiModelProperty(value = "巡查车")
    @TableField("PATROL_VEHICLE_")
    private String patrolVehicle;

    @ApiModelProperty(value = "双排车")
    @TableField("SONGTHAEW_")
    private String songthaew;

    @ApiModelProperty(value = "翻斗货车")
    @TableField("TIPPER_TRUCK_")
    private String tipperTruck;

    @ApiModelProperty(value = "撒布机")
    @TableField("SPREADER_")
    private String spreader;
}
