package com.artfess.yhxt.specialproject.manager.impl;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.specialproject.model.BizProjectContractDetails;
import com.artfess.yhxt.specialproject.dao.BizProjectContractDetailsDao;
import com.artfess.yhxt.specialproject.manager.BizProjectContractDetailsManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 项目合同明细表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-10
 */
@Service
public class BizProjectContractDetailsManagerImpl extends BaseManagerImpl<BizProjectContractDetailsDao, BizProjectContractDetails> implements BizProjectContractDetailsManager {

    @Override
    public PageList<BizProjectContractDetails> queryBizProjectContractDetails(QueryFilter<BizProjectContractDetails> queryFilter) {
        IPage<BizProjectContractDetails> result =  baseMapper.queryBizProjectContractDetails(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public BizProjectContractDetails getBizProjectContractDetailsById(String id) {
        BizProjectContractDetails bizProjectContractDetails = baseMapper.selectById(id);
        return bizProjectContractDetails;
    }

    @Override
    public List<BizProjectContractDetails> selectListById(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("IS_DELE_","0");
        queryWrapper.eq("CONTRACT_ID_", id);
        return this.baseMapper.selectList(queryWrapper);
    }

    @Override
    public void setIsDele(String id) {
        UpdateWrapper<BizProjectContractDetails> updateWrapper = new UpdateWrapper<>();
        updateWrapper.in("ID_",id);
        updateWrapper.set("IS_DELE_","0");
        this.baseMapper.update(null, updateWrapper);
    }

    @Override
    public void removeContract(String ContractId) {
        UpdateWrapper<BizProjectContractDetails> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("CONTRACT_ID_",ContractId);
        updateWrapper.set("is_dele_","1");
        this.update(null,updateWrapper);
    }
}
