package com.artfess.yhxt.specialproject.manager.impl;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.specialproject.manager.BizEngineeringAccessoriesManager;
import com.artfess.yhxt.specialproject.model.BizEngineeringAccessories;
import com.artfess.yhxt.specialproject.model.BizMigrantWorkersInformation;
import com.artfess.yhxt.specialproject.model.BizMigrantWorkersInformation;
import com.artfess.yhxt.specialproject.dao.BizMigrantWorkersInformationDao;
import com.artfess.yhxt.specialproject.manager.BizMigrantWorkersInformationManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.yhxt.specialproject.model.BizMigrantWorkersInformation;
import com.artfess.yhxt.specialproject.vo.BizMigrantWorkersInformationVo;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * 民工信息表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-11
 */
@Service
public class BizMigrantWorkersInformationManagerImpl extends BaseManagerImpl<BizMigrantWorkersInformationDao, BizMigrantWorkersInformation> implements BizMigrantWorkersInformationManager {

    @Resource
    private BizEngineeringAccessoriesManager bizEngineeringAccessoriesManager;

    @Override
    public PageList<BizMigrantWorkersInformation> queryBizMigrantWorkersInformation(QueryFilter<BizMigrantWorkersInformation> queryFilter) {
        IPage<BizMigrantWorkersInformation> result = baseMapper.queryBizMigrantWorkersInformation(convert2IPage(queryFilter.getPageBean()),convert2Wrapper(queryFilter,currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public BizMigrantWorkersInformation getBizMigrantWorkersInformationById(String id) {
        BizMigrantWorkersInformation bizMigrantWorkersInformation = baseMapper.selectById(id);
        return bizMigrantWorkersInformation;
    }

    @Override
    public void saveVo(BizMigrantWorkersInformationVo bizMigrantWorkersInformationVo) {
        //保存民工信息
        BizMigrantWorkersInformation bizMigrantWorkersInformation = bizMigrantWorkersInformationVo.getBizMigrantWorkersInformation();
        this.create(bizMigrantWorkersInformation);
        //附件
        List<BizEngineeringAccessories> bizEngineeringAccessoriesList = bizMigrantWorkersInformationVo.getBizEngineeringAccessoriesList();
        String sourceId = bizMigrantWorkersInformation.getId();
        bizEngineeringAccessoriesList.forEach(s -> {
            s.setSourceId(sourceId);
            s.setValidFlag(1);
        });
        this.bizEngineeringAccessoriesManager.saveOrUpdateBatch(bizEngineeringAccessoriesList);
    }

    @Override
    public void updateVo(BizMigrantWorkersInformationVo bizMigrantWorkersInformationVo) {
        //修改民工信息
        BizMigrantWorkersInformation bizMigrantWorkersInformation = bizMigrantWorkersInformationVo.getBizMigrantWorkersInformation();
        this.update(bizMigrantWorkersInformation);
        String sourceId = bizMigrantWorkersInformation.getId();
        List<BizEngineeringAccessories> bizEngineeringAccessoriesList = bizMigrantWorkersInformationVo.getBizEngineeringAccessoriesList();
        bizEngineeringAccessoriesManager.removeEngineeringAccessories(sourceId);
        bizEngineeringAccessoriesList.forEach(s -> {
            s.setSourceId(sourceId);
            s.setValidFlag(1);
        });
        this.bizEngineeringAccessoriesManager.saveOrUpdateBatch(bizEngineeringAccessoriesList);
    }

    @Override
    public BizMigrantWorkersInformationVo getVo(String id) {

        BizMigrantWorkersInformationVo bizMigrantWorkersInformationVo= new BizMigrantWorkersInformationVo();
        BizMigrantWorkersInformation bizMigrantWorkersInformation = this.getById(id);
        List<BizEngineeringAccessories> engineeringAccessories = this.bizEngineeringAccessoriesManager.getEngineeringAccessoriesBySourceId(id);
        bizMigrantWorkersInformationVo.setBizMigrantWorkersInformation(bizMigrantWorkersInformation);
        bizMigrantWorkersInformationVo.setBizEngineeringAccessoriesList(engineeringAccessories);
        return bizMigrantWorkersInformationVo;
    }
}
