package com.artfess.yhxt.specialproject.manager.impl;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.specialproject.model.BizContractChangeInvalid;
import com.artfess.yhxt.specialproject.dao.BizContractChangeInvalidDao;
import com.artfess.yhxt.specialproject.manager.BizContractChangeInvalidManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;

/**
 * 合同信息变更待生效表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-12
 */
@Service
public class BizContractChangeInvalidManagerImpl extends BaseManagerImpl<BizContractChangeInvalidDao, BizContractChangeInvalid> implements BizContractChangeInvalidManager {

    @Override
    public PageList<BizContractChangeInvalid> queryBizContractChangeInvalid(QueryFilter<BizContractChangeInvalid> queryFilter) {
        IPage<BizContractChangeInvalid> result = baseMapper.queryBizContractChangeInvalid(convert2IPage(queryFilter.getPageBean()),convert2Wrapper(queryFilter,currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public BizContractChangeInvalid getBizContractChangeInvalidById(String id) {
        BizContractChangeInvalid bizContractChangeInvalid = baseMapper.selectById(id);
        return bizContractChangeInvalid;
    }
}
