package com.artfess.yhxt.specialcheck.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.poi.util.ExcelUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.specialcheck.model.BizMqiCheckDetail;
import com.artfess.yhxt.specialcheck.manager.BizMqiCheckDetailManager;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * MQI检查数据表明细表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-13
 */
@RestController
@RequestMapping("/bizMqiCheckDetail/v1/")
@Api(tags = "MQI数据检查明细接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizMqiCheckDetailController extends BaseController<BizMqiCheckDetailManager, BizMqiCheckDetail> {
    @RequestMapping(value="/importData", method= RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "mqi详细检查导入-进库", httpMethod = "POST", notes = "mqi详细检查导入-进库")
    public CommonResult<String> importData(@ApiParam(name="mqiId",value="mqiId",required=true)  @RequestParam String mqiId,
                                           @ApiParam(name = "file", value = "上传的文件流") @RequestBody MultipartFile file) throws Exception{

        CommonResult<String> commonResult = baseService.importData(mqiId, file);
        return commonResult;
    }
    @RequestMapping(value="/import", method= RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "获取mqi详细检查导入信息-不进库", httpMethod = "POST", notes = "获取mqi详细检查导入信息-不进库")
    public CommonResult<List<BizMqiCheckDetail>> getimportData(@ApiParam(name = "file", value = "上传的文件流") @RequestBody MultipartFile file) throws Exception{

        CommonResult<List<BizMqiCheckDetail>> commonResult = baseService.getimportData(file);
        return commonResult;
    }

    @RequestMapping(value="/export", method= RequestMethod.GET, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "获取mqi详细检查导出", httpMethod = "GET", notes = "获取mqi详细检查导出")
    public void export( @ApiParam(name="id",value="id", required = false)@RequestParam String id,HttpServletResponse response) throws Exception{
        baseService.exportMqiDetail(id,response);
    }
}
