package com.artfess.yhxt.open.base.util;

import com.artfess.base.conf.JwtConfig;
import com.artfess.base.jwt.JwtTokenHandler;
import com.artfess.yhxt.basedata.manager.*;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Clock;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.impl.DefaultClock;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

/**
 * @author zhx
 * @create 2022/2/14
 */
@Component
public class JwtCheckUtils {
    @Resource
    JwtConfig jwtConfig;


    private final List<String> accessKeyList = Arrays.asList("59zDDSsqq7Kkrf04Dtn3", "gPH2qC81nzk5y19eI63Y", "8A19AdZhisHjuQPKUyXB", "I7C3uDuTP4LqvN0DDJgm", "ZVrG0vlqQQciC4A8r0gh");

    private Clock clock = DefaultClock.INSTANCE;
    //验证token是否正确
    public boolean checkToken(String token) {
        try {
            Claims claims = Jwts.parser()
                    .setSigningKey(jwtConfig.getSecret())
                    .parseClaimsJws(token)
                    .getBody();
            Object accessKey = claims.get("accessKey");
            return accessKeyList.stream().anyMatch(s -> s.equals(accessKey));
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }


    //验证token是否正确
    public String getTokenAccessKey(String token) {
        try {
            Claims claims = Jwts.parser()
                    .setSigningKey(jwtConfig.getSecret())
                    .parseClaimsJws(token)
                    .getBody();
            Object accessKey = claims.get("accessKey");

            return accessKey.toString();
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

}
