package com.artfess.yhxt.disease.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.basedata.model.Accessory;
import com.artfess.yhxt.disease.model.Disease;
import com.artfess.base.manager.BaseManager;
import com.artfess.yhxt.disease.vo.DiseaseReportVO;
import com.artfess.yhxt.statistics.vo.Org4DiseaseVO;
import com.artfess.yhxt.statistics.vo.OrgDisease4AppVO;
import org.springframework.web.multipart.MultipartFile;
import javax.servlet.http.HttpServletResponse;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 病害管理表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-09
 */
public interface DiseaseManager extends BaseManager<Disease> {

    /**
     * 分页查询病害信息
     * @param queryFilter
     * @return
     */
    PageList<Disease> queryDisease(QueryFilter<Disease> queryFilter);

    Accessory minioDiseaseUpload(MultipartFile file, String sourceId);

    void minioDiseaseDel(List<String> asList);


    void minIoDiseaseDownFile(String ids, HttpServletResponse response) throws Exception;

    /**
     * 根据桥梁ID查询病害信息
     * @param queryFilter
     * @return
     */
    PageList<Disease> getJsonBridgeDiseaseCheck(QueryFilter<Disease> queryFilter);

    /**
     * 涵洞Id
     * @param queryFilter
     * @return
     */
    PageList<Disease> getJsonCulvertDiseaseCheck(QueryFilter<Disease> queryFilter);

    /**
     * 隧道
     * @param queryFilter
     * @return
     */
    PageList<Disease> getJsonTunnelDiseaseCheck(QueryFilter<Disease> queryFilter);

    /**
     * 边坡
     * @param queryFilter
     * @return
     */
    PageList<Disease> getJsonSideDiseaseCheck(QueryFilter<Disease> queryFilter);

    /**
     * 计算超时日期
     */
    LocalDateTime calculateDeadline(LocalDateTime checkDate);

    /**
     * 保存病害、附件信息
     * @param disease 病害vo
     */
    void saveDiseaseVo(Disease disease);

    /**
     * 保存病害、附件信息
     * @param disease 病害vo
     */
    void updateDiseaseVo(Disease disease);

    /**
     * 根据ID查询病害信息、附件信息
     * @param id 病害ID
     * @return
     */
    Disease getByIdDisease(String id);

    List<Org4DiseaseVO> getDiseaseCount(String year);

    OrgDisease4AppVO getDisease4AppCount(String level,String dimension,String date);

    List<DiseaseReportVO> diseaseReport(String year,String orgId);
}
