package com.artfess.yhxt.check.regular.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.yhxt.check.regular.manager.CulvertOftenCheckManager;
import com.artfess.yhxt.check.regular.model.BridgeOftenCheck;
import com.artfess.yhxt.check.regular.model.CulvertOftenCheck;
import com.artfess.yhxt.check.regular.model.SideSlopeOftenCheck;
import com.artfess.yhxt.check.regular.model.TunnelOftenCheck;
import com.artfess.yhxt.check.regular.vo.BridgeArchivesVo;
import com.artfess.yhxt.check.regular.vo.CulvertArchivesVo;
import com.artfess.yhxt.check.regular.vo.SideSlopArchivesVo;
import com.artfess.yhxt.check.regular.vo.TunnelArchivesVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;


/**
 * 结构物档案管理
 *
 * @company 阿特菲斯信息技术有限公司
 * @author naf
 * @since 2022-04-17
 */
//@RestController
//@RequestMapping("/structureArchivesController/v1/")
//@Api(tags = "结构物档案管理")
//@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class StructureArchivesController {


    @Autowired
    private CulvertOftenCheckManager culvertOftenCheckManager;



    @RequestMapping(value="culvert",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "分页查询涵洞结构物档案管理",httpMethod = "POST")
    public PageList<CulvertArchivesVo> getCulvertArchivesVo(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<CulvertOftenCheck> queryFilter) {
        queryFilter.addFilter("IS_DELE_", "0", QueryOP.EQUAL);
        PageList<CulvertArchivesVo> pageList = new PageList<>();

        return  pageList;
    }

    @RequestMapping(value="bridge",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "分页查询桥梁结构物档案管理",httpMethod = "POST")
    public PageList<BridgeArchivesVo> getBridgeArchivesVo(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<BridgeOftenCheck> queryFilter) {
        queryFilter.addFilter("IS_DELE_", "0", QueryOP.EQUAL);
        PageList<BridgeArchivesVo> pageList = new PageList<>();

        return  pageList;
    }

    @RequestMapping(value="tunnel",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "分页查询隧道结构物档案管理",httpMethod = "POST")
    public PageList<TunnelArchivesVo> getTunnelArchivesVo(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<TunnelOftenCheck> queryFilter) {
        queryFilter.addFilter("IS_DELE_", "0", QueryOP.EQUAL);
        PageList<TunnelArchivesVo> pageList = new PageList<>();

        return  pageList;
    }

    @RequestMapping(value="sideSlop",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "分页查询边坡结构物档案管理",httpMethod = "POST")
    public PageList<SideSlopArchivesVo> getSideSlopArchivesVo(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<SideSlopeOftenCheck> queryFilter) {
        queryFilter.addFilter("IS_DELE_", "0", QueryOP.EQUAL);
        PageList<SideSlopArchivesVo> pageList = new PageList<>();

        return  pageList;
    }




}
