package com.artfess.yhxt.basedata.vo;

import com.artfess.yhxt.basedata.model.SideSlopeInformation;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author zhx
 * @create 2021/8/17
 */
@ApiModel(value="边坡定期检查 VO对象")
@Data
public class SideSlopeRegularVo extends SideSlopeInformation {
    @ApiModelProperty(value = "检查日期")
    @TableField("CHECK_DATE_")
    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    private Date checkDate;


    @ApiModelProperty(value = "下次检查日期")
    @TableField("CHECK_NEW_DAY_")
    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    private Date checkNewDay;


    @ApiModelProperty(value = "总体状况评定等级")
    @TableField(exist = false)
    private String overallRating;

    @ApiModelProperty(value = "总体状况评定等级值")
    @TableField(exist = false)
    private String overallRatingValue;

    @ApiModelProperty(value = "涵洞定期预警时间")
    @TableField(exist = false)
    private String value;

    @ApiModelProperty(value = "距检查天数")
    @TableField(exist = false)
    private Integer checkDays;
    @ApiModelProperty(value = "距上次检查天数")
    @TableField(exist = false)
    private Integer alreadyCheckDays;

    @ApiModelProperty(value = "是否临期 0:未临期 1:临期")
    @TableField(exist = false)
    private Integer temporary;
}
