package com.artfess.yhxt.basedata.dao;

import com.artfess.yhxt.basedata.model.BizCarEquipment;
import com.artfess.yhxt.basedata.vo.BizCarEquipmentVO;
import com.artfess.yhxt.basedata.vo.BizRoadIndexCodeVO;
import com.artfess.yhxt.basedata.vo.CarVO;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 车辆设备表 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2022-08-30
 */
public interface BizCarEquipmentDao extends BaseMapper<BizCarEquipment> {

    @Select("SELECT\n" +
            "\tcamera_index_code_ AS cameraIndexCode,\n" +
            "\tgb_index_code_ AS gbIndexCode,\n" +
            "\tdevice_index_code_ AS deviceIndexCode,\n" +
            "\troad_index_code_id_ AS roadIndexCodeId,\n" +
            "\tcamera_name_ AS name,\n" +
            "\tlongitude,\n" +
            "\tlatitude,\n" +
            "\tSTATUS,\n" +
            "\ttrans_type AS transType \n" +
            "FROM\n" +
            "\tbiz_car_equipment \n" +
            "WHERE\n" +
            "\troad_index_code_id_ = #{roadId} \n" +
            "\tAND name_ = #{name}")
    List<BizRoadIndexCodeVO> selectdetail(@Param("roadId")String road,@Param("name")String name);

    @Select("SELECT\n" +
            "\tname_ as name\n" +
            "FROM\n" +
            "\tbiz_car_equipment \n" +
            "WHERE\n" +
            "\troad_index_code_id_ = #{roadId} \n" +
            "GROUP BY\n" +
            "\tname_")
    List<BizRoadIndexCodeVO> carNames(@Param("roadId")String road);

}
