package com.artfess.yhxt.basedata.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.yhxt.basedata.manager.BizMaterialsManagementManager;
import com.artfess.yhxt.basedata.model.BizMaterialsManagement;
import com.artfess.yhxt.basedata.vo.BizEmergeMaterialManagementVO;
import com.artfess.yhxt.contract.manager.BillQuantiTypeManagManager;
import com.artfess.yhxt.contract.vo.BizEmergeMaterialManagementGoodsVo;
import com.artfess.yhxt.schedule.StatisticsSchedule;
import com.artfess.yhxt.statistics.vo.Org4emergeVO;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.basedata.model.BizEmergeMaterialManagement;
import com.artfess.yhxt.basedata.manager.BizEmergeMaterialManagementManager;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.util.List;

/**
 * 应急物资库管理 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xmz
 * @since 2022-04-19
 */
@RestController
@RequestMapping("/bizEmergeMaterialManagement/v1/")
@Api(tags = "应急物资库管理")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizEmergeMaterialManagementController extends BaseController<BizEmergeMaterialManagementManager, BizEmergeMaterialManagement> {

    @Resource
    private BizMaterialsManagementManager bizMaterialsManagementManager;


    @RequestMapping(value = "getEmergeVo", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取物资库统计", httpMethod = "POST", notes = "获取物资库统计")
    public List<Org4emergeVO> getEmergeVo() throws Exception {
        return baseService.getEmergeCount();
    }


    @RequestMapping(value = "getByManId", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "根据id获取物资库明细", httpMethod = "POST", notes = "获取物资库统计")
    public BizEmergeMaterialManagementVO getByManId(String id) throws Exception {

        BizEmergeMaterialManagementVO vo = new BizEmergeMaterialManagementVO();

        QueryWrapper<BizMaterialsManagement> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("STRUCTURAL_ID_",id);
        List<BizMaterialsManagement> list = bizMaterialsManagementManager.list(queryWrapper);
        vo.setMaterialsManagements(list);

        return vo;
    }





    @PostMapping("/query")
    @ApiOperation(value = "应急物资库管理-分页", httpMethod = "POST", notes = "应急物资库管理-分页")
    public PageList<BizEmergeMaterialManagementVO> queryEmergeMaterialManagement(@ApiParam(name = "queryFilter", value = "查询对象") @RequestBody QueryFilter<BizEmergeMaterialManagement> queryFilter)  {

        return baseService.queryEmergeMaterialManagement(queryFilter);
    }

    @PostMapping("save")
    @ApiOperation(value = "保存或修改应急物资库", httpMethod = "POST", notes = "保存或修改应急物资库")
    public CommonResult<String> save(@RequestBody BizEmergeMaterialManagement bizEmergeMaterialManagement)  {
        baseService.saveOrUpdate(bizEmergeMaterialManagement);
        return new CommonResult<>(true,"操作成功");
    }
    @PostMapping("saveVo")
    @ApiOperation(value = "保存或修改应急物资库包括物资数量", httpMethod = "POST", notes = "保存或修改应急物资库")
    public CommonResult<String> saveVo(@RequestBody BizEmergeMaterialManagementGoodsVo vo)  {

        this.baseService.saveOrUpdateManagementGoodsVo(vo);
        return new CommonResult<>(true,"操作成功");
    }

    @RequestMapping(value="/importData", method= RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "应急物资库管理明细导入", httpMethod = "POST", notes = "应急物资库管理明细导入")
    public CommonResult<String> importData(@ApiParam(name="manId",value="应急物资库ID",required=true)  @RequestParam String manId,
                                           @ApiParam(name = "file", value = "上传的文件流") @RequestBody MultipartFile file) throws Exception{

        CommonResult<String> commonResult = this.baseService.importData(manId, file);
        return commonResult;
    }

}
