/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.schedule;

import com.artfess.base.entity.BizModel;
import com.artfess.yhxt.basedata.manager.BizCulvertInformationManager;
import com.artfess.yhxt.basedata.manager.BizVehicleManager;
import com.artfess.yhxt.basedata.manager.BridgeInformationManager;
import com.artfess.yhxt.basedata.manager.RoadManager;
import com.artfess.yhxt.basedata.manager.SideSlopeInformationManager;
import com.artfess.yhxt.basedata.manager.TunnelInformationManager;
import com.artfess.yhxt.basedata.model.BizCulvertInformation;
import com.artfess.yhxt.basedata.model.Road;
import com.artfess.yhxt.basedata.model.SideSlopeInformation;
import com.artfess.yhxt.basedata.model.TunnelInformation;
import com.artfess.yhxt.budget.dao.YearBudgetDetailedDao;
import com.artfess.yhxt.budget.manager.YearBudgetDetailedManager;
import com.artfess.yhxt.budget.manager.YearBudgetManager;
import com.artfess.yhxt.budget.model.YearBudget;
import com.artfess.yhxt.budget.model.YearBudgetDetailed;
import com.artfess.yhxt.check.regular.dao.BridgeOftenCheckDao;
import com.artfess.yhxt.check.regular.dao.CulvertOftenCheckDao;
import com.artfess.yhxt.check.regular.dao.SideSlopeOftenCheckDao;
import com.artfess.yhxt.check.regular.dao.TunnelOftenCheckDao;
import com.artfess.yhxt.contract.dao.WorkOrderInformationDao;
import com.artfess.yhxt.contract.manager.BillOfQuantitiesManager;
import com.artfess.yhxt.contract.manager.WorkOrderInformationManager;
import com.artfess.yhxt.contract.model.BillOfQuantities;
import com.artfess.yhxt.contract.model.WorkOrderInformation;
import com.artfess.yhxt.specialcheck.manager.SiteInspectionManager;
import com.artfess.yhxt.specialcheck.model.SiteInspection;
import com.artfess.yhxt.statistics.dao.SiteStatisticDao;
import com.artfess.yhxt.statistics.dao.WorkStatisticDao;
import com.artfess.yhxt.statistics.dao.YearBudgetSumDao;
import com.artfess.yhxt.statistics.manager.BaseDataStatisticsManager;
import com.artfess.yhxt.statistics.model.CamerasRequest;
import com.artfess.yhxt.statistics.model.SiteStatistic;
import com.artfess.yhxt.statistics.model.WorkStatistic;
import com.artfess.yhxt.statistics.model.YearBudgetSum;
import com.artfess.yhxt.yjjy.manager.SiteInspectionYjjyManager;
import com.artfess.yhxt.yjjy.model.SiteInspectionYjjy;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@EnableScheduling
public class StatisticsSchedule {
    @Resource
    private WorkOrderInformationManager workOrderInformationManager;
    @Resource
    private RoadManager roadManager;
    @Resource
    private WorkStatisticDao workStatisticDao;
    @Resource
    private TunnelInformationManager tunnelInformationManager;
    @Resource
    private TunnelOftenCheckDao tunnelOftenCheckDao;
    @Resource
    private SideSlopeInformationManager sideSlopeInformationManager;
    @Resource
    private SideSlopeOftenCheckDao sideSlopeOftenCheckDao;
    @Resource
    private BridgeInformationManager bridgeInformationManager;
    @Resource
    private BridgeOftenCheckDao bridgeOftenCheckDao;
    @Resource
    private BizCulvertInformationManager bizCulvertInformationManager;
    @Resource
    private CulvertOftenCheckDao culvertOftenCheckDao;
    @Resource
    private SiteStatisticDao siteStatisticDao;
    @Resource
    private YearBudgetManager yearBudgetManager;
    @Resource
    private YearBudgetDetailedManager yearBudgetDetailedManager;
    @Resource
    BaseDataStatisticsManager baseDataStatisticsManager;
    @Resource
    private BillOfQuantitiesManager billOfQuantitiesManager;
    @Resource
    private YearBudgetSumDao yearBudgetSumDao;
    @Resource
    private SiteInspectionYjjyManager siteInspectionYjjyManager;
    @Resource
    private SiteInspectionManager siteInspectionManager;
    @Resource
    private BizVehicleManager bizVehicleManager;
    @Resource
    private WorkOrderInformationDao workOrderInformationDao;
    @Resource
    private YearBudgetDetailedDao yearBudgetDetailedDao;

    @Scheduled(cron="0 0 5 * * ?")
    @Transactional(rollbackFor={Exception.class})
    public void carEquipment() {
        this.bizVehicleManager.synchronizationCarData();
    }

    @Scheduled(cron="0 0 2 * * ?")
    @Transactional(rollbackFor={Exception.class})
    public void scheduleWorkeCount() throws ParseException {
        List<WorkOrderInformation> selectOverdue = this.workOrderInformationDao.selectOverdue();
        for (WorkOrderInformation overdue : selectOverdue) {
            if (overdue.getEndTime() != null || !overdue.getDemandFinishTime().isBefore(LocalDate.now())) continue;
            overdue.setOverdue(1);
            this.workOrderInformationDao.updateById((Object)overdue);
        }
        this.workOrderInformationDao.updateOverdue();
        Calendar c = Calendar.getInstance();
        c.setTime(new SimpleDateFormat("yyyy-MM-dd").parse(LocalDateTime.now().toString()));
        c.add(2, 0);
        c.set(5, 1);
        String first = new SimpleDateFormat("yyyy-MM-dd").format(c.getTime());
        String mouth = new SimpleDateFormat("yyyy-MM").format(c.getTime());
        String year = new SimpleDateFormat("yyyy").format(c.getTime());
        Calendar ca = Calendar.getInstance();
        ca.set(5, ca.getActualMaximum(5));
        String last = new SimpleDateFormat("yyyy-MM-dd").format(ca.getTime());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        List list = this.roadManager.list((Wrapper)queryWrapper);
        for (Road road : list) {
            QueryWrapper queryWrapperWork = new QueryWrapper();
            String rodeSegmentId = road.getId();
            queryWrapperWork.eq((Object)"ROAD_SEGMENT_ID_", (Object)rodeSegmentId);
            queryWrapperWork.ge((Object)"END_TIME_", (Object)first);
            queryWrapperWork.le((Object)"END_TIME_", (Object)last);
            List<WorkOrderInformation> workOrderInformations = this.workOrderInformationManager.listFinishWork(rodeSegmentId, first, last);
            QueryWrapper queryWrapperWorkOrder = new QueryWrapper();
            queryWrapperWorkOrder.eq((Object)"ROAD_SEGMENT_ID_", (Object)rodeSegmentId);
            queryWrapperWorkOrder.ge((Object)"ISSUE_DATE_", (Object)first);
            queryWrapperWorkOrder.le((Object)"ISSUE_DATE_", (Object)last);
            List<WorkOrderInformation> workOrderInformationList = this.workOrderInformationManager.listWorkAll(rodeSegmentId, first, last);
            QueryWrapper queryWrapperStatistic = new QueryWrapper();
            queryWrapperStatistic.eq((Object)"ACC_DATE_MONTH_", (Object)mouth);
            queryWrapperStatistic.eq((Object)"ROAD_SEGMENT_ID_", (Object)rodeSegmentId);
            WorkStatistic workStatistic = (WorkStatistic)((Object)this.workStatisticDao.selectOne((Wrapper)queryWrapperStatistic));
            if (workStatistic == null) {
                workStatistic = new WorkStatistic();
                if (workOrderInformationList.size() - workOrderInformations.size() > 0) {
                    workStatistic.setTotalNumsNo(String.valueOf(workOrderInformationList.size() - workOrderInformations.size()));
                } else {
                    workStatistic.setTotalNumsNo("0");
                }
                workStatistic.setAccDateMonth(mouth);
                workStatistic.setAccDateYear(year);
                workStatistic.setRoadSegmentId(rodeSegmentId);
                workStatistic.setRoadSegmentName(road.getName());
                workStatistic.setCompanyId(road.getCompanyId());
                workStatistic.setCompanyName(road.getCompanyName());
                workStatistic.setTotalNums(String.valueOf(workOrderInformations.size()));
                this.workStatisticDao.insert((Object)workStatistic);
                continue;
            }
            workStatistic.setTotalNums(String.valueOf(workOrderInformations.size()));
            if (workOrderInformationList.size() - workOrderInformations.size() > 0) {
                workStatistic.setTotalNumsNo(String.valueOf(workOrderInformationList.size() - workOrderInformations.size()));
            } else {
                workStatistic.setTotalNumsNo("0");
            }
            this.workStatisticDao.updateById((Object)workStatistic);
        }
    }

    @Scheduled(cron="0 0 1 * * ?")
    @Transactional(rollbackFor={Exception.class})
    public void scheduleYearBudget() {
        try {
            int year = LocalDateTime.now().getYear();
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
            List roadList = this.roadManager.getBaseMapper().selectList((Wrapper)queryWrapper);
            for (Road road : roadList) {
                YearBudgetSum yearBudgetSum;
                QueryWrapper queryWrapperYearBudget = new QueryWrapper();
                queryWrapperYearBudget.eq((Object)"IS_DELE_", (Object)"0");
                queryWrapperYearBudget.eq((Object)"ROAD_SEGMENT_ID_", (Object)road.getId());
                queryWrapperYearBudget.eq((Object)"ASCRIPTION_YEAR_", (Object)String.valueOf(year));
                YearBudget yearBudget = (YearBudget)((Object)this.yearBudgetManager.getOne((Wrapper)queryWrapperYearBudget));
                BigDecimal rcjf = new BigDecimal(0);
                BigDecimal frczx = new BigDecimal(0);
                BigDecimal rcjd = new BigDecimal(0);
                BigDecimal zxjd = new BigDecimal(0);
                if (yearBudget != null) {
                    Object aFloat2;
                    QueryWrapper yearBudgetDetailedQueryWrapperFRCZX = new QueryWrapper();
                    yearBudgetDetailedQueryWrapperFRCZX.eq((Object)"YEAR_BUDGET_ID_", (Object)yearBudget.getId());
                    yearBudgetDetailedQueryWrapperFRCZX.eq((Object)"BUDGET_TYPE_", (Object)"FRCZX");
                    yearBudgetDetailedQueryWrapperFRCZX.eq((Object)"IS_DELE_", (Object)"0");
                    QueryWrapper yearBudgetDetailedQueryWrapperRCJF = new QueryWrapper();
                    yearBudgetDetailedQueryWrapperRCJF.eq((Object)"YEAR_BUDGET_ID_", (Object)yearBudget.getId());
                    yearBudgetDetailedQueryWrapperRCJF.eq((Object)"BUDGET_TYPE_", (Object)"RCJF");
                    yearBudgetDetailedQueryWrapperRCJF.eq((Object)"IS_DELE_", (Object)"0");
                    List zxList = this.yearBudgetDetailedManager.list((Wrapper)yearBudgetDetailedQueryWrapperFRCZX);
                    frczx = frczx.add(zxList.stream().filter(s -> s != null && s.getTotalPrice() != null).map(YearBudgetDetailed::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
                    zxjd = zxjd.add(zxList.stream().filter(s -> s != null && s.getImageProgress() != null).map(YearBudgetDetailed::getImageProgress).reduce(BigDecimal.ZERO, BigDecimal::add));
                    List WorkOrderInformationIds = this.workOrderInformationManager.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ROAD_SEGMENT_ID_", (Object)road.getId())).isNotNull((Object)"END_TIME_")).apply("date_format(ISSUE_DATE_,'%Y') = {0}", new Object[]{year})).stream().map(WorkOrderInformation::getId).collect(Collectors.toList());
                    BigDecimal workOrderMoney = new BigDecimal(0);
                    if (WorkOrderInformationIds.size() > 0) {
                        List worlMoneyF = this.billOfQuantitiesManager.list((Wrapper)new QueryWrapper().in((Object)"WORK_ORDER_INFORMATION_ID_", WorkOrderInformationIds)).stream().filter(s -> s != null && s.getTaxMoney() != null).map(BillOfQuantities::getTaxMoney).collect(Collectors.toList());
                        for (Object aFloat2 : worlMoneyF) {
                            workOrderMoney = workOrderMoney.add(new BigDecimal(Float.toString(((Float)aFloat2).floatValue())));
                        }
                    }
                    QueryWrapper detailedQueryWrapper = new QueryWrapper();
                    detailedQueryWrapper.eq((Object)"YEAR_BUDGET_ID_", (Object)yearBudget.getId());
                    detailedQueryWrapper.eq((Object)"IS_DELE_", (Object)"0");
                    detailedQueryWrapper.eq((Object)"EXPENDITURE_TYPE_", (Object)"FXCBXZC");
                    detailedQueryWrapper.eq((Object)"BUDGET_TYPE_", (Object)"RCJF");
                    detailedQueryWrapper.eq((Object)"BUDGET_ITEM_", (Object)"RCYH");
                    detailedQueryWrapper.eq((Object)"BUDGET_CONTENT", (Object)"\u65e5\u5e38\u517b\u62a4");
                    List detaileds = this.yearBudgetDetailedManager.list((Wrapper)detailedQueryWrapper);
                    aFloat2 = detaileds.iterator();
                    while (aFloat2.hasNext()) {
                        YearBudgetDetailed detailed = (YearBudgetDetailed)((Object)aFloat2.next());
                        detailed.setImageProgress(workOrderMoney.divide(new BigDecimal("10000"), 2, RoundingMode.DOWN));
                        this.yearBudgetDetailedManager.update((Model)detailed);
                    }
                    List rcList = this.yearBudgetDetailedManager.list((Wrapper)yearBudgetDetailedQueryWrapperRCJF);
                    rcjf = rcjf.add(rcList.stream().filter(s -> s != null && s.getTotalPrice() != null).map(YearBudgetDetailed::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
                    rcjd = rcjd.add(rcList.stream().filter(s -> s != null && s.getImageProgress() != null).map(YearBudgetDetailed::getImageProgress).reduce(BigDecimal.ZERO, BigDecimal::add));
                    yearBudget.setAlreadyCount(this.yearBudgetDetailedDao.sumImageProgress(yearBudget.getId()));
                    this.yearBudgetManager.updateById((Object)yearBudget);
                }
                if (null == (yearBudgetSum = (YearBudgetSum)((Object)this.yearBudgetSumDao.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ACC_DATE_YEAR_", (Object)year)).eq((Object)"ROAD_SEGMENT_ID_", (Object)road.getId()))))) {
                    yearBudgetSum = new YearBudgetSum();
                    yearBudgetSum.setCompanyId(road.getCompanyId());
                    yearBudgetSum.setCompanyName(road.getCompanyName());
                    yearBudgetSum.setRoadSegmentId(road.getId());
                    yearBudgetSum.setRoadSegmentName(road.getName());
                    yearBudgetSum.setAccDateYear(year);
                    yearBudgetSum.setBudgetSum(String.valueOf(rcjf.add(frczx)));
                    yearBudgetSum.setConserveMoneyBudget(String.valueOf(rcjf));
                    yearBudgetSum.setSpecialMoneyBudget(String.valueOf(frczx));
                    yearBudgetSum.setAlreadyCount(String.valueOf(rcjd.add(zxjd).setScale(2)));
                    yearBudgetSum.setConserveMoney(String.valueOf(rcjd));
                    yearBudgetSum.setSpecialMoney(String.valueOf(zxjd));
                    this.yearBudgetSumDao.insert((Object)yearBudgetSum);
                    continue;
                }
                yearBudgetSum.setBudgetSum(String.valueOf(rcjf.add(frczx)));
                yearBudgetSum.setConserveMoneyBudget(String.valueOf(rcjf));
                yearBudgetSum.setSpecialMoneyBudget(String.valueOf(frczx));
                yearBudgetSum.setAlreadyCount(String.valueOf(rcjd.add(zxjd).setScale(2)));
                yearBudgetSum.setConserveMoney(String.valueOf(rcjd));
                yearBudgetSum.setSpecialMoney(String.valueOf(zxjd));
                this.yearBudgetSumDao.updateById((Object)yearBudgetSum);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Scheduled(cron="0 30 0 * * ?")
    @Transactional(rollbackFor={Exception.class})
    public void scheduleSiteStatistic() {
        String mouth = new SimpleDateFormat("yyyy-MM").format(new Date());
        String year = new SimpleDateFormat("yyyy").format(new Date());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        List list = this.roadManager.list((Wrapper)queryWrapper);
        for (Road road : list) {
            QueryWrapper queryWrapperBridge = new QueryWrapper();
            queryWrapperBridge.eq((Object)"ROAD_SEGMENT_ID_", (Object)road.getId());
            queryWrapperBridge.eq((Object)"IS_DELE_", (Object)"0");
            List bridgeInformations = this.bridgeInformationManager.list((Wrapper)queryWrapperBridge);
            String ids = bridgeInformations.stream().map(s -> s.getId()).collect(Collectors.joining(","));
            int countBridgeOftenCheck = StringUtils.isEmpty((CharSequence)ids) ? 0 : this.bridgeOftenCheckDao.countBridgeOften(ids, mouth);
            QueryWrapper queryWrapperCulvert = new QueryWrapper();
            queryWrapperCulvert.eq((Object)"ROAD_SEGMENT_ID_", (Object)road.getId());
            queryWrapperCulvert.eq((Object)"IS_DELE_", (Object)"0");
            String culvertIds = this.bizCulvertInformationManager.list((Wrapper)queryWrapperCulvert).stream().map(BizCulvertInformation::getId).collect(Collectors.joining(","));
            int countCulvertOften = StringUtils.isEmpty((CharSequence)culvertIds) ? 0 : this.culvertOftenCheckDao.countCulvertOften(culvertIds, mouth);
            QueryWrapper queryWrapperSide = new QueryWrapper();
            queryWrapperSide.eq((Object)"ROAD_SEGMENT_ID_", (Object)road.getId());
            queryWrapperSide.eq((Object)"IS_DELE_", (Object)"0");
            String sideSlopeIds = this.sideSlopeInformationManager.list((Wrapper)queryWrapperSide).stream().map(SideSlopeInformation::getId).collect(Collectors.joining(","));
            int countSideSlope = StringUtils.isEmpty((CharSequence)sideSlopeIds) ? 0 : this.sideSlopeOftenCheckDao.countSideSlopeOften(sideSlopeIds, mouth);
            QueryWrapper queryWrapperTunnel = new QueryWrapper();
            queryWrapperTunnel.eq((Object)"ROAD_SEGMENT_ID_", (Object)road.getId());
            queryWrapperTunnel.eq((Object)"IS_DELE_", (Object)"0");
            String tunnelIds = this.tunnelInformationManager.list((Wrapper)queryWrapperTunnel).stream().map(TunnelInformation::getId).collect(Collectors.joining(","));
            int countTunnelOften = StringUtils.isEmpty((CharSequence)tunnelIds) ? 0 : this.tunnelOftenCheckDao.countTunnelOften(tunnelIds, mouth);
            QueryWrapper queryWrapperSiteInspection = new QueryWrapper();
            queryWrapperSiteInspection.eq((Object)"ROAD_SEGMENT_ID_", (Object)road.getId());
            queryWrapperSiteInspection.eq((Object)"TYPE_", (Object)1);
            queryWrapperSiteInspection.apply("date_format(PATROL_DATE_,'%Y-%m') = {0}", new Object[]{mouth});
            Long countDayFlish = 0L;
            Long countDayUnFlish = 0L;
            List listSiteDay = this.siteInspectionManager.list((Wrapper)queryWrapperSiteInspection);
            countDayFlish = listSiteDay.stream().filter(s -> "3".equals(s.getHandStatus())).count();
            countDayUnFlish = listSiteDay.stream().filter(s -> "2".equals(s.getHandStatus())).count();
            QueryWrapper queryWrapperSiteInspectionNight = new QueryWrapper();
            queryWrapperSiteInspectionNight.eq((Object)"ROAD_SEGMENT_ID_", (Object)road.getId());
            queryWrapperSiteInspectionNight.eq((Object)"TYPE_", (Object)2);
            queryWrapperSiteInspectionNight.apply("date_format(PATROL_DATE_,'%Y-%m') = {0}", new Object[]{mouth});
            List listNight = this.siteInspectionManager.list((Wrapper)queryWrapperSiteInspectionNight);
            Long countNightFlish = 0L;
            Long countNightUnFlish = 0L;
            countNightFlish = listNight.stream().filter(s -> "3".equals(s.getHandStatus())).count();
            countNightUnFlish = listNight.stream().filter(s -> "2".equals(s.getHandStatus())).count();
            QueryWrapper queryWrapperSiteStatistic = new QueryWrapper();
            queryWrapperSiteStatistic.eq((Object)"ACC_DATE_MONTH_", (Object)mouth);
            queryWrapperSiteStatistic.eq((Object)"ACC_DATE_YEAR_", (Object)year);
            queryWrapperSiteStatistic.eq((Object)"ROAD_SEGMENT_ID_", (Object)road.getId());
            queryWrapperSiteStatistic.eq((Object)"SITE_CODE_", (Object)3);
            SiteStatistic siteStatisticBrideOften = (SiteStatistic)((Object)this.siteStatisticDao.selectOne((Wrapper)queryWrapperSiteStatistic));
            if (siteStatisticBrideOften == null) {
                siteStatisticBrideOften = new SiteStatistic();
                siteStatisticBrideOften.setAccDateMonth(mouth);
                siteStatisticBrideOften.setAccDateYear(year);
                siteStatisticBrideOften.setCompanyId(road.getCompanyId());
                siteStatisticBrideOften.setCompanyName(road.getCompanyName());
                siteStatisticBrideOften.setSiteCode(3);
                siteStatisticBrideOften.setSiteName("\u6865\u6881\u7ecf\u5e38\u68c0\u67e5");
                siteStatisticBrideOften.setRoadSegmentId(road.getId());
                siteStatisticBrideOften.setRoadSegmentName(road.getName());
                siteStatisticBrideOften.setComplete(String.valueOf(countBridgeOftenCheck));
                siteStatisticBrideOften.setCompleteNo("0");
                this.siteStatisticDao.insert((Object)siteStatisticBrideOften);
            } else {
                siteStatisticBrideOften.setComplete(String.valueOf(countBridgeOftenCheck));
                this.siteStatisticDao.updateById((Object)siteStatisticBrideOften);
            }
            QueryWrapper queryWrapperSiteStatistic2 = new QueryWrapper();
            queryWrapperSiteStatistic2.eq((Object)"ACC_DATE_MONTH_", (Object)mouth);
            queryWrapperSiteStatistic2.eq((Object)"ACC_DATE_YEAR_", (Object)year);
            queryWrapperSiteStatistic2.eq((Object)"ROAD_SEGMENT_ID_", (Object)road.getId());
            queryWrapperSiteStatistic2.eq((Object)"SITE_CODE_", (Object)4);
            SiteStatistic siteStatisticTunnel = (SiteStatistic)((Object)this.siteStatisticDao.selectOne((Wrapper)queryWrapperSiteStatistic2));
            if (siteStatisticTunnel == null) {
                siteStatisticTunnel = new SiteStatistic();
                siteStatisticTunnel.setAccDateMonth(mouth);
                siteStatisticTunnel.setAccDateYear(year);
                siteStatisticTunnel.setCompanyId(road.getCompanyId());
                siteStatisticTunnel.setCompanyName(road.getCompanyName());
                siteStatisticTunnel.setSiteCode(4);
                siteStatisticTunnel.setSiteName("\u96a7\u9053\u7ecf\u5e38\u68c0\u67e5");
                siteStatisticTunnel.setRoadSegmentId(road.getId());
                siteStatisticTunnel.setRoadSegmentName(road.getName());
                siteStatisticTunnel.setComplete(String.valueOf(countTunnelOften));
                siteStatisticTunnel.setCompleteNo("0");
                this.siteStatisticDao.insert((Object)siteStatisticTunnel);
            } else {
                siteStatisticTunnel.setComplete(String.valueOf(countTunnelOften));
                this.siteStatisticDao.updateById((Object)siteStatisticTunnel);
            }
            QueryWrapper queryWrapperSiteStatistic3 = new QueryWrapper();
            queryWrapperSiteStatistic3.eq((Object)"ACC_DATE_MONTH_", (Object)mouth);
            queryWrapperSiteStatistic3.eq((Object)"ACC_DATE_YEAR_", (Object)year);
            queryWrapperSiteStatistic3.eq((Object)"ROAD_SEGMENT_ID_", (Object)road.getId());
            queryWrapperSiteStatistic3.eq((Object)"SITE_CODE_", (Object)5);
            SiteStatistic siteStatisticCulvertOften = (SiteStatistic)((Object)this.siteStatisticDao.selectOne((Wrapper)queryWrapperSiteStatistic3));
            if (siteStatisticCulvertOften == null) {
                siteStatisticCulvertOften = new SiteStatistic();
                siteStatisticCulvertOften.setAccDateMonth(mouth);
                siteStatisticCulvertOften.setAccDateYear(year);
                siteStatisticCulvertOften.setCompanyId(road.getCompanyId());
                siteStatisticCulvertOften.setCompanyName(road.getCompanyName());
                siteStatisticCulvertOften.setSiteCode(5);
                siteStatisticCulvertOften.setSiteName("\u6db5\u6d1e\u7ecf\u5e38\u68c0\u67e5");
                siteStatisticCulvertOften.setRoadSegmentId(road.getId());
                siteStatisticCulvertOften.setRoadSegmentName(road.getName());
                siteStatisticCulvertOften.setComplete(String.valueOf(countCulvertOften));
                siteStatisticCulvertOften.setCompleteNo("0");
                this.siteStatisticDao.insert((Object)siteStatisticCulvertOften);
            } else {
                siteStatisticCulvertOften.setComplete(String.valueOf(countCulvertOften));
                this.siteStatisticDao.updateById((Object)siteStatisticCulvertOften);
            }
            QueryWrapper queryWrapperSiteStatistic4 = new QueryWrapper();
            queryWrapperSiteStatistic4.eq((Object)"ACC_DATE_MONTH_", (Object)mouth);
            queryWrapperSiteStatistic4.eq((Object)"ACC_DATE_YEAR_", (Object)year);
            queryWrapperSiteStatistic4.eq((Object)"ROAD_SEGMENT_ID_", (Object)road.getId());
            queryWrapperSiteStatistic4.eq((Object)"SITE_CODE_", (Object)6);
            SiteStatistic siteStatisticSideSlope = (SiteStatistic)((Object)this.siteStatisticDao.selectOne((Wrapper)queryWrapperSiteStatistic4));
            if (siteStatisticSideSlope == null) {
                siteStatisticSideSlope = new SiteStatistic();
                siteStatisticSideSlope.setAccDateMonth(mouth);
                siteStatisticSideSlope.setAccDateYear(year);
                siteStatisticSideSlope.setCompanyId(road.getCompanyId());
                siteStatisticSideSlope.setCompanyName(road.getCompanyName());
                siteStatisticSideSlope.setSiteCode(6);
                siteStatisticSideSlope.setSiteName("\u8fb9\u5761\u7ecf\u5e38\u68c0\u67e5");
                siteStatisticSideSlope.setRoadSegmentId(road.getId());
                siteStatisticSideSlope.setRoadSegmentName(road.getName());
                siteStatisticSideSlope.setComplete(String.valueOf(countSideSlope));
                siteStatisticSideSlope.setCompleteNo("0");
                this.siteStatisticDao.insert((Object)siteStatisticSideSlope);
            } else {
                siteStatisticSideSlope.setComplete(String.valueOf(countSideSlope));
                this.siteStatisticDao.updateById((Object)siteStatisticSideSlope);
            }
            QueryWrapper queryWrapperSiteStatistic5 = new QueryWrapper();
            queryWrapperSiteStatistic5.eq((Object)"ACC_DATE_MONTH_", (Object)mouth);
            queryWrapperSiteStatistic5.eq((Object)"ACC_DATE_YEAR_", (Object)year);
            queryWrapperSiteStatistic5.eq((Object)"ROAD_SEGMENT_ID_", (Object)road.getId());
            queryWrapperSiteStatistic5.eq((Object)"SITE_CODE_", (Object)1);
            SiteStatistic siteInspectionDay = (SiteStatistic)((Object)this.siteStatisticDao.selectOne((Wrapper)queryWrapperSiteStatistic5));
            if (siteInspectionDay == null) {
                siteInspectionDay = new SiteStatistic();
                siteInspectionDay.setAccDateMonth(mouth);
                siteInspectionDay.setAccDateYear(year);
                siteInspectionDay.setCompanyId(road.getCompanyId());
                siteInspectionDay.setCompanyName(road.getCompanyName());
                siteInspectionDay.setSiteCode(1);
                siteInspectionDay.setSiteName("\u65e5\u5de1\u68c0");
                siteInspectionDay.setRoadSegmentId(road.getId());
                siteInspectionDay.setRoadSegmentName(road.getName());
                siteInspectionDay.setComplete(String.valueOf(countDayFlish));
                siteInspectionDay.setCompleteNo(String.valueOf(countDayUnFlish));
                this.siteStatisticDao.insert((Object)siteInspectionDay);
            } else {
                siteInspectionDay.setComplete(String.valueOf(countDayFlish));
                siteInspectionDay.setCompleteNo(String.valueOf(countDayUnFlish));
                this.siteStatisticDao.updateById((Object)siteInspectionDay);
            }
            QueryWrapper queryWrapperSiteStatistic6 = new QueryWrapper();
            queryWrapperSiteStatistic6.eq((Object)"ACC_DATE_MONTH_", (Object)mouth);
            queryWrapperSiteStatistic6.eq((Object)"ACC_DATE_YEAR_", (Object)year);
            queryWrapperSiteStatistic6.eq((Object)"ROAD_SEGMENT_ID_", (Object)road.getId());
            queryWrapperSiteStatistic6.eq((Object)"SITE_CODE_", (Object)2);
            SiteStatistic siteInspectionNight = (SiteStatistic)((Object)this.siteStatisticDao.selectOne((Wrapper)queryWrapperSiteStatistic6));
            if (siteInspectionNight == null) {
                siteInspectionNight = new SiteStatistic();
                siteInspectionNight.setAccDateMonth(mouth);
                siteInspectionNight.setAccDateYear(year);
                siteInspectionNight.setCompanyId(road.getCompanyId());
                siteInspectionNight.setCompanyName(road.getCompanyName());
                siteInspectionNight.setSiteCode(2);
                siteInspectionNight.setSiteName("\u591c\u5de1\u68c0");
                siteInspectionNight.setRoadSegmentId(road.getId());
                siteInspectionNight.setRoadSegmentName(road.getName());
                siteInspectionNight.setComplete(String.valueOf(countNightFlish));
                siteInspectionNight.setCompleteNo(String.valueOf(countNightUnFlish));
                this.siteStatisticDao.insert((Object)siteInspectionNight);
                continue;
            }
            siteInspectionNight.setComplete(String.valueOf(countNightFlish));
            siteInspectionNight.setCompleteNo(String.valueOf(countNightUnFlish));
            this.siteStatisticDao.updateById((Object)siteInspectionNight);
        }
    }

    @Scheduled(cron="0 0 0/4 * * ?")
    @Transactional(rollbackFor={Exception.class})
    public void scheduleSiteinspection() {
        List list = this.siteInspectionYjjyManager.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SiteInspectionYjjy::getSStatus, (Object)"\u5b8c\u6210")).or()).eq(SiteInspectionYjjy::getSStatus, (Object)"\u5de1\u67e5\u4e2d"));
        ArrayList siteInspections = new ArrayList();
        list.forEach(s -> {
            Road road = (Road)((Object)((Object)this.roadManager.getOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(Road::getCode, (Object)s.getSRoad())).eq(BizModel::getIsDele, (Object)"0"))));
            if (road != null) {
                SiteInspection siteInspection = new SiteInspection();
                siteInspection.setId(s.getId());
                siteInspection.setRoadSegmentId(road.getId());
                siteInspection.setRoadSegmentName(road.getName());
                siteInspection.setRouteId(road.getRouteId());
                siteInspection.setRouteName(road.getRouteName());
                siteInspection.setCompanyId(road.getCompanyId());
                siteInspection.setCompanyName(road.getCompanyName());
                if ("\u5b8c\u6210".equals(s.getSStatus())) {
                    siteInspection.setHandStatus("3");
                }
                if ("\u5de1\u67e5\u4e2d".equals(s.getSStatus())) {
                    siteInspection.setHandStatus("2");
                }
                System.out.println(s.getDBeginTime().toLocalDate().toString());
                siteInspection.setPatrolDate(s.getDBeginTime().toLocalDate());
                siteInspection.setContent(s.getSTaskValue());
                if ("\u767d\u73ed".equals(s.getSClass())) {
                    siteInspection.setType(1);
                } else {
                    siteInspection.setType(2);
                }
                siteInspection.setFullname(s.getSDoPersonName());
                siteInspection.setWeatherValue(s.getSWeather());
                siteInspections.add(siteInspection);
            }
        });
        this.siteInspectionManager.saveOrUpdateBatch(siteInspections);
    }

    @Scheduled(cron="0 0 4 * * ?")
    @Transactional(rollbackFor={Exception.class})
    public void getCamerasSchedule() {
        CamerasRequest camerasRequest = new CamerasRequest();
        camerasRequest.setPageNo(1);
        camerasRequest.setPageSize(1);
        camerasRequest.setTreeCode("0");
        this.baseDataStatisticsManager.getCameras(camerasRequest);
    }
}

