/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.basedata.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.context.BaseContext;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.StringUtil;
import com.artfess.yhxt.basedata.manager.BizVehicleManager;
import com.artfess.yhxt.basedata.model.BizVehicle;
import com.artfess.yhxt.basedata.vo.BizRoadIndexCodeVO;
import com.artfess.yhxt.basedata.vo.VehicleCountVo;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/bizVehicle/v1/"})
@Api(tags={"\u8f66\u8f86\u7ba1\u7406"})
@ApiGroup(group={"group_biz"})
public class BizVehicleController
extends BaseController<BizVehicleManager, BizVehicle> {
    @Resource
    BizVehicleManager bizVehicleManager;
    @Resource
    BaseContext baseContext;
    @Resource
    PermissionUtils permissionUtils;

    @RequestMapping(value={"getVehicleCountVo"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u8f66\u8f86\u7edf\u8ba1", httpMethod="POST", notes="\u83b7\u53d6\u8f66\u8f86\u7edf\u8ba1")
    public List<VehicleCountVo> getVehicleCountVo() throws Exception {
        return ((BizVehicleManager)this.baseService).getVehicleCountVo();
    }

    @PostMapping(value={"/list"})
    @ApiOperation(value="\u8f66\u8f86\u7ba1\u7406\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u8f66\u8f86\u7ba1\u7406\u5217\u8868")
    public PageList<BizVehicle> list(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<BizVehicle> queryFilter) throws Exception {
        queryFilter.addFilter("is_dele_", (Object)"0", QueryOP.EQUAL);
        if (StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId())) {
            this.permissionUtils.addPermission(queryFilter);
        }
        return this.bizVehicleManager.query(queryFilter);
    }

    @GetMapping(value={"/synCarData"})
    @ApiOperation(value="\u8f66\u8f86\u4fe1\u606f\u540c\u6b65", httpMethod="GET", notes="\u8f66\u8f86\u4fe1\u606f\u540c\u6b65")
    public CommonResult synCarData() throws Exception {
        this.bizVehicleManager.synchronizationCarData();
        return new CommonResult(true, "\u6210\u529f");
    }

    @GetMapping(value={"/getCarList"})
    @ApiOperation(value="\u8f66\u8f86\u8bbe\u5907", httpMethod="GET", notes="\u8f66\u8f86\u8bbe\u5907")
    public CommonResult<List<BizRoadIndexCodeVO>> getCarList() throws Exception {
        return new CommonResult(true, "", this.bizVehicleManager.findAll());
    }

    @GetMapping(value={"/get/{id}"})
    @ApiOperation(value="\u8f66\u8f86\u7ba1\u7406\u6570\u636e\u8be6\u60c5", httpMethod="GET", notes="\u8f66\u8f86\u7ba1\u7406\u6570\u636e\u8be6\u60c5")
    public BizVehicle get(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @PathVariable String id) throws Exception {
        return (BizVehicle)this.bizVehicleManager.get((Serializable)((Object)id));
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u8f66\u8f86\u7ba1\u7406\u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u8f66\u8f86\u7ba1\u7406\u6570\u636e")
    public CommonResult<String> save(@ApiParam(name="BizVehicle", value="\u8f66\u8f86\u7ba1\u7406\u4e1a\u52a1\u5bf9\u8c61", required=true) @RequestBody BizVehicle BizVehicle2) throws Exception {
        String msg = "\u6dfb\u52a0\u8f66\u8f86\u7ba1\u7406\u6210\u529f";
        if (StringUtil.isEmpty((String)String.valueOf(BizVehicle2.getId()))) {
            BizVehicle2.setIsDele("0");
            this.bizVehicleManager.create((Model)BizVehicle2);
        } else {
            this.bizVehicleManager.update((Model)BizVehicle2);
            msg = "\u66f4\u65b0\u8f66\u8f86\u7ba1\u7406\u6210\u529f";
        }
        return new CommonResult(msg);
    }

    @DeleteMapping(value={"/remove/{id}"})
    @ApiOperation(value="\u5220\u9664\u8f66\u8f86\u7ba1\u7406\u8bb0\u5f55", httpMethod="DELETE", notes="\u5220\u9664\u8f66\u8f86\u7ba1\u7406\u8bb0\u5f55")
    public CommonResult<String> remove(@ApiParam(name="id", value="\u4e1a\u52a1\u4e3b\u952e", required=true) @PathVariable String id) throws Exception {
        this.bizVehicleManager.remove((Serializable)((Object)id));
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @DeleteMapping(value={"/removes"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u8f66\u8f86\u7ba1\u7406\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u8f66\u8f86\u7ba1\u7406\u8bb0\u5f55")
    public CommonResult<String> removes(String ... ids) throws Exception {
        this.bizVehicleManager.removeByIds(Arrays.asList(ids));
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/getList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4e0d\u5206\u9875\u67e5\u8be2\u6db5\u6d1e\u660e\u7ec6\u4fe1\u606f", httpMethod="POST")
    public PageList<BizVehicle> getList(@ApiParam(name="queryFilter", value="\u4e0d\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizVehicle> queryFilter) {
        queryFilter.addFilter("is_dele_", (Object)"0", QueryOP.EQUAL);
        PageBean pageBean = queryFilter.getPageBean();
        pageBean.setPageSize(PageBean.WITHOUT_PAGE.intValue());
        pageBean.setPage(1);
        queryFilter.setPageBean(pageBean);
        PageList<BizVehicle> road = ((BizVehicleManager)this.baseService).queryBizVehicle(queryFilter);
        return road;
    }

    @RequestMapping(value={"/getJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6db5\u6d1e\u660e\u7ec6\u4fe1\u606f", httpMethod="POST")
    public PageList<BizVehicle> getJson(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizVehicle> queryFilter) {
        queryFilter.addFilter("is_dele_", (Object)"0", QueryOP.EQUAL);
        PageList<BizVehicle> pageList = ((BizVehicleManager)this.baseService).queryBizVehicle(queryFilter);
        return pageList;
    }

    @RequestMapping(value={"updateVehicle"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u903b\u8f91\u5220\u9664", httpMethod="DELETE", notes="\u6279\u91cf\u903b\u8f91\u5220\u9664")
    public CommonResult<String> updateVehicle(@ApiParam(name="ids", value="\u6db5\u6d1eID\u96c6\u5408\u4ee5\uff0c\u9694\u5f00", required=true) @RequestParam(value="ids", required=true) String ids) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.in((Object)"id_", idsList);
            updateWrapper.set((Object)"is_dele_", (Object)"1");
            this.bizVehicleManager.update(null, (Wrapper)updateWrapper);
        }
        return new CommonResult(true, "\u6279\u91cf\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/minioDrawingUpload"})
    @ApiOperation(value="\u4e0a\u4f20\u7167\u7247")
    public String minioDrawingUpload(MultipartFile file) {
        String fileurl = ((BizVehicleManager)this.baseService).minioDrawingUpload(file);
        return fileurl;
    }

    @PostMapping(value={"/minioVehicleDelete"})
    @ApiOperation(value="\u5220\u9664\u7167\u7247")
    public CommonResult<String> minioVehicleDelete(String url) {
        ((BizVehicleManager)this.baseService).minioDrawingDelete(url);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }
}

