/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.specialproject.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.util.ContextUtil;
import com.artfess.yhxt.specialproject.dao.ProjectOverApplyForDao;
import com.artfess.yhxt.specialproject.manager.BizEngineeringAccessoriesManager;
import com.artfess.yhxt.specialproject.manager.ProjectOverApplyForManager;
import com.artfess.yhxt.specialproject.model.BizEngineeringAccessories;
import com.artfess.yhxt.specialproject.model.ProjectOverApplyFor;
import com.artfess.yhxt.specialproject.vo.ProjectOverApplyForVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import net.hasor.utils.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProjectOverApplyForManagerImpl
extends BaseManagerImpl<ProjectOverApplyForDao, ProjectOverApplyFor>
implements ProjectOverApplyForManager {
    @Resource
    private BaseContext baseContext;
    @Resource
    private BizEngineeringAccessoriesManager bizEngineeringAccessoriesManager;

    @Override
    public PageList<ProjectOverApplyFor> queryProjectOverApplyFor(QueryFilter<ProjectOverApplyFor> queryFilter) {
        IPage<ProjectOverApplyFor> result = ((ProjectOverApplyForDao)this.baseMapper).queryProjectOverApplyFor((IPage<ProjectOverApplyFor>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<ProjectOverApplyFor>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveProjectOverApplyFor(ProjectOverApplyFor projectOverApplyFor) {
        projectOverApplyFor.setIsDele("0");
        projectOverApplyFor.setStartupTime(LocalDate.now());
        projectOverApplyFor.setApplyUserId(this.baseContext.getCurrentUserId());
        projectOverApplyFor.setApplyUserName(this.baseContext.getCurrentUserName());
        projectOverApplyFor.setApplyUserOrgId(this.baseContext.getCurrentOrgId());
        projectOverApplyFor.setApplyUserOrg(this.baseContext.getCurrentOrgName());
        projectOverApplyFor.setConfirmStatus(0);
        this.create((Model)projectOverApplyFor);
    }

    @Override
    public void updateProjectOverApplyFor(ProjectOverApplyFor projectOverApplyFor) {
        this.update((Model)projectOverApplyFor);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void ownerUserAudit(String ids, String ownerDescription, Integer confirmStatu) {
        if (StringUtils.isNotBlank((String)ids)) {
            List<String> list = Arrays.asList(ids.split(","));
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.in((Object)"ID_", list);
            IGroup currentGroup = ContextUtil.getCurrentGroup();
            updateWrapper.set((Object)"OWNER_USER_ID_", (Object)this.baseContext.getCurrentUserId());
            updateWrapper.set((Object)"OWNER_USER_NAME_", (Object)this.baseContext.getCurrentUserName());
            updateWrapper.set((Object)"OWNER_USER_ORG_ID_", (Object)this.baseContext.getCurrentOrgId());
            updateWrapper.set((Object)"OWNER_USER_ORG_", (Object)this.baseContext.getCurrentOrgName());
            updateWrapper.set((Object)"OWNER_TIME_", (Object)LocalDate.now());
            updateWrapper.set((Object)"OWNER_DESCRIPTION_", (Object)ownerDescription);
            updateWrapper.set((Object)"CONFIRM_STATUS_", (Object)confirmStatu);
            this.update(null, (Wrapper)updateWrapper);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void confirmUserAudit(String ids, String confirmDescription, Integer confirmStatus) {
        if (StringUtils.isNotBlank((String)ids)) {
            List<String> list = Arrays.asList(ids.split(","));
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.in((Object)"ID_", list);
            updateWrapper.set((Object)"CONFIRM_USER_ID_", (Object)this.baseContext.getCurrentUserId());
            updateWrapper.set((Object)"CONFIRM_USER_NAME_", (Object)this.baseContext.getCurrentUserName());
            updateWrapper.set((Object)"CONFIRM_USER_ORG_ID_", (Object)this.baseContext.getCurrentOrgId());
            updateWrapper.set((Object)"CONFIRM_USER_ORG_", (Object)this.baseContext.getCurrentOrgName());
            updateWrapper.set((Object)"CONFIRM_TIME_", (Object)LocalDate.now());
            updateWrapper.set((Object)"OWNER_DESCRIPTION_", (Object)confirmDescription);
            updateWrapper.set((Object)"CONFIRM_STATUS_", (Object)confirmStatus);
            this.update(null, (Wrapper)updateWrapper);
        }
    }

    @Override
    public void saveVo(ProjectOverApplyForVo projectOverApplyForVo) {
        ProjectOverApplyFor projectOverApplyFor = projectOverApplyForVo.getProjectOverApplyFor();
        projectOverApplyFor.setIsDele("0");
        projectOverApplyFor.setConfirmStatus(0);
        projectOverApplyFor.setStartupTime(LocalDate.now());
        projectOverApplyFor.setApplyUserId(this.baseContext.getCurrentUserId());
        projectOverApplyFor.setApplyUserName(this.baseContext.getCurrentUserName());
        projectOverApplyFor.setApplyUserOrgId(this.baseContext.getCurrentOrgId());
        projectOverApplyFor.setApplyUserOrg(this.baseContext.getCurrentOrgName());
        projectOverApplyFor.setConfirmStatus(0);
        this.create((Model)projectOverApplyFor);
        List<BizEngineeringAccessories> bizEngineeringAccessoriesList = projectOverApplyForVo.getBizEngineeringAccessoriesList();
        String sourceId = projectOverApplyFor.getId();
        bizEngineeringAccessoriesList.forEach(s -> {
            s.setSourceId(sourceId);
            s.setValidFlag(1);
        });
        this.bizEngineeringAccessoriesManager.saveOrUpdateBatch(bizEngineeringAccessoriesList);
    }

    @Override
    public void updateVo(ProjectOverApplyForVo projectOverApplyForVo) {
        ProjectOverApplyFor projectOverApplyFor = projectOverApplyForVo.getProjectOverApplyFor();
        Integer confirmStatus = projectOverApplyFor.getConfirmStatus();
        if (null != confirmStatus && confirmStatus == 2) {
            projectOverApplyFor.setConfirmStatus(0);
        }
        if (null != confirmStatus && confirmStatus == 4) {
            projectOverApplyFor.setConfirmStatus(0);
        }
        this.update((Model)projectOverApplyFor);
        String sourceId = projectOverApplyFor.getId();
        List<BizEngineeringAccessories> bizEngineeringAccessoriesList = projectOverApplyForVo.getBizEngineeringAccessoriesList();
        this.bizEngineeringAccessoriesManager.removeEngineeringAccessories(sourceId);
        bizEngineeringAccessoriesList.forEach(s -> {
            s.setSourceId(sourceId);
            s.setValidFlag(1);
        });
        this.bizEngineeringAccessoriesManager.saveOrUpdateBatch(bizEngineeringAccessoriesList);
    }

    @Override
    public ProjectOverApplyForVo getVo(String id) {
        ProjectOverApplyForVo projectOverApplyForVo = new ProjectOverApplyForVo();
        ProjectOverApplyFor projectOverApplyFor = (ProjectOverApplyFor)((Object)this.getById((Serializable)((Object)id)));
        projectOverApplyForVo.setProjectOverApplyFor(projectOverApplyFor);
        List<BizEngineeringAccessories> bizEngineeringAccessoriesList = this.bizEngineeringAccessoriesManager.getEngineeringAccessoriesBySourceId(id);
        projectOverApplyForVo.setBizEngineeringAccessoriesList(bizEngineeringAccessoriesList);
        return projectOverApplyForVo;
    }
}

