package com.artfess.cqxy.projectManagement.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.projectManagement.vo.MergeItemsVo;
import com.artfess.cqxy.projectManagement.vo.ProjectLandCostVo;
import com.artfess.sysConfig.persistence.model.SysMenu;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 项目管理表(BizProjectManagement)表服务接口
 *
 * @author 黎沐华
 * @since 2022-02-10 15:43:44
 */
public interface ProjectManagementManager extends BaseManager<ProjectManagement> {

    void importExcelData(MultipartFile file);

    public void exportDatatoExcel(QueryFilter<ProjectManagement> queryFilter, HttpServletResponse response) throws IOException;

    /**
     * 保存数据时，获取排序号
     * @return 下一条排序号
     */
    Integer createSnNum();

    /**
     * 分页查询所有数据
     * @param queryFilter 通用查询器
     * @return 数据集合
     */
    PageList<ProjectManagement> queryAllByPage(QueryFilter<ProjectManagement> queryFilter);


    /**
     * 分组查询各个项目类型的数据
     * @param queryFilter 通用查询器
     * @return 数据集合
     */
    List<Map<String, Object>> queryProjectMoneyGroupByType(QueryFilter<ProjectManagement> queryFilter);

    /**
     * 分页查询所有数据（不会根据用户权限过滤项目）
     * @param queryFilter 通用查询器
     * @return 数据集合
     */
    PageList<ProjectManagement> noFilterPage(QueryFilter<ProjectManagement> queryFilter);


    /**
     * 不分页查询
     * @param queryFilter
     * @return
     */
    List<ProjectManagement> queryList(QueryFilter<ProjectManagement> queryFilter);


    /**
     * 设为当前项目
     * @param id 主键
     * @return num
     */
    int setCurrentProject(String id);

    /**
     * 验证是否存在【当前项目】
     * @return 有 / 无
     */
    boolean hasCurrentProject();

    /**
     * 新增数据，需要获取回填的ID，故写到Service层
     * @param pm 新增数据
     * @return 成功对象
     */
    boolean savePm(ProjectManagement pm);

    /**
     * 通过项目ID修改hasChildren
     * @param parentId
     */
    void updateHasChildrenByParentId(String parentId);

    /**
     * 通过项目ID修改项目状态
     * @param id id
     */
    void updateStatusById(String id, Integer status);

    /**
     * 合并项目
     * @param mergeItemsVo 合并项目对象
     */
    void mergeItems(MergeItemsVo mergeItemsVo);

    /**
     * 根据项目ID修改父项目的ID
     * @param parentId 父项目的ID
     * @param ids 项目id，多个使用逗号耿凯
     */
    void updateParentIdByIds(String parentId, String ids);

    /**
     * 将多个项目拆分为独立项目
     * @param ids 项目id，多个使用逗号分隔
     */
    void splitItems(String ids);

    /**
     * 根据项目id修改全过程造价咨询单位
     * @param id
     * @param costConsultation
     */
    void updateCostConsultationById(String id, String costConsultation);

    /**
     * 根据项目ID修改土地费用
     * @param projectLandCostVo
     */
    void updateLandCostById(ProjectLandCostVo projectLandCostVo);
}

