package com.artfess.cqxy.processManagermant.model;


import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import com.artfess.base.entity.BizModel;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 过程管理 - 进度管理 - 疫情防控(BizProgressManageEpidemicControl)表实体类
 *
 * @author 黎沐华
 * @since 2022-03-22 11:31:39
 */
@Data
@TableName("BIZ_PROGRESS_MANAGE_EPIDEMIC_CONTROL")
@ApiModel(value="施工过程-安全文明施工-其他-ProgressManageEpidemicControl", description="施工过程-安全文明施工-其他")
public class ProgressManageEpidemicControl extends BizModel<ProgressManageEpidemicControl> {

    // 关联项目的信息放在开头，以便在导出时先导出项目中的配置，而不用进行额外的位置配置
    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的项目信息")
    private ProjectManagement projectInfo;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID（关联项目管理表ID）")
    private String projectId;

    @Excel(name = "编号/文号")
    @TableField("EPIDEMIC_CONTROL_CODE_")
    @ApiModelProperty(value = "编号/文号")
    private String epidemicControlCode;

    @Excel(name = "主要内容")
    @TableField("EPIDEMIC_CONTROL_VIEW_")
    @ApiModelProperty(value = "主要内容")
    private String epidemicControlView;

    @Excel(name = "批复/检查日期",format = "yyyy-MM-dd")
    @TableField("EPIDEMIC_CONTROL_DATE_")
    @ApiModelProperty(value = "批复/检查日期，（日期格式，yyy-dd-mm，默认为当天）")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date epidemicControlDate;

    @Excel(name = "负责人")
    @TableField("EPIDEMIC_CONTROL_USER_")
    @ApiModelProperty(value = "负责人")
    private String epidemicControlUser;

    @Excel(name = "审批/检查结果")
    @TableField("PROGRESS_DESCRIPTION_")
    @ApiModelProperty(value = "审批/检查结果")
    private String progressDescription;

    @Excel(name = "备注")
    @TableField("REMARKS_")
    @ApiModelProperty(value = "备注")
    private String remarks;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件信息")
    private List<Accessory> accessoryInfo;

    /**
     * 获取主键值
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "ProgressManageEpidemicControl{" +
                "id='" + id + '\'' +
                ", projectId='" + projectId + '\'' +
                ", epidemicControlCode=" + epidemicControlCode +
                ", epidemicControlDate=" + epidemicControlDate +
                ", epidemicControlUser='" + epidemicControlUser + '\'' +
                ", progressDescription='" + progressDescription + '\'' +
                ", epidemicControlView='" + epidemicControlView + '\'' +
                ", remarks='" + remarks + '\'' +
                ", projectInfo=" + projectInfo +
                ", accessoryInfo=" + accessoryInfo +
                '}';
    }

}

