package com.artfess.cqxy.ledger.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.feasiblePlan.model.PlanningSelectionSite;
import com.artfess.cqxy.ledger.manager.ContractLedgerManager;
import com.artfess.cqxy.ledger.manager.ProjectLedgerManager;
import com.artfess.cqxy.ledger.vo.ProjectLedgerVo;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Limuhua
 * @date 2022/3/15 15:34
 */
@Slf4j
@RestController
@Api(tags = "台账-项目信息台账接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@RequestMapping("/biz/ledger/projectLedger/v1")
public class ProjectLedgerController{

    @Autowired
    private ProjectLedgerManager manager;

    /**
     * 分页查询所有数据
     * @param queryFilter 通用查询器
     * @return 分页数据
     */
    @PostMapping("/typeData")
    @ApiOperation(value = "S-所有类型统计数据", httpMethod = "POST")
    public CommonResult<List<Map<String, String>>> typeData(@ApiParam(name = "queryFilter",value = "通用查询器")
                                                                @RequestBody QueryFilter<ProjectManagement> queryFilter) {
        List<Map<String, String>> result = manager.getCollect(queryFilter);
        return new CommonResult<>(true,"操作成功",result);
    }

    /**
     * 分页查询所有数据
     * @param queryFilter 通用查询器
     * @return 分页数据
     */
    @PostMapping("/page")
    @ApiOperation(value = "S-分页查询所有数据",notes = "查询字段：必须传入项目类型 PROJECT_TYPE_；XX年项目即开工时间为 COMMENCEMENT_TIME_\n" +
            "其余字段参见 Swagger Models 中【台账-项目台账对象-ProjectLedgerVo】字段，将驼峰命名规则应用为下划线规则", httpMethod = "POST")
    public CommonResult<Map<String, Object>>  page(
            @ApiParam(name = "queryFilter",value = "通用查询器")
            @RequestBody QueryFilter<ProjectManagement> queryFilter) {
        Map<String, Object> result = manager.getDataByPage(queryFilter);
        return new CommonResult<>(true, "操作成功", result);
    }

    /**
     * 导出数据到Excel
     * @param queryFilter 通用查询器
     * @param response 响应对象
     * @return 通用结果
     * @throws IOException IO异常
     */
    @PostMapping("/exportDataToExcel")
    @ApiOperation(value = "S-导出数据到Excel",notes = "使用项目管理查询器")
    public CommonResult exportDataToExcel (@ApiParam(name = "queryFilter",value = "通用查询器")@RequestBody QueryFilter<ProjectManagement> queryFilter, HttpServletResponse response) throws Exception {
        log.debug("导出数据到Excel接口请求参数：{}",queryFilter,response);
        manager.exportDatatoExcel(queryFilter,response);
        return new CommonResult<>("导出成功");
    }

}
