package com.artfess.cqxy.feasiblePlan.model;


import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import com.artfess.base.entity.BizModel;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 可研批复表(BizFeasibilityStudyReply)表实体类
 * @author 黎沐华
 * @since 2022-02-14 16:09:40
 */
@Data
@TableName("biz_feasibility_study_reply")
@ApiModel(value="可研规划-可研批复对象-FeasibilityStudyReply", description="可研批复表")
public class FeasibilityStudyReply extends BizModel<FeasibilityStudyReply> {

    // 关联项目的信息放在开头，以便在导出时先导出项目中的配置，而不用进行额外的位置配置
    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的项目信息")
    private ProjectManagement projectInfo;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID（关联项目管理表ID）")
    private String projectId;

//    @Excel(name = "文号")
    @TableField("DOCUMENT_NUMBER_")
    @ApiModelProperty(value = "文号")
    private String documentNumber="";

//    @Excel(name = "批复日期",format = "yyyy-MM-dd")
    @TableField("ESTABLISHMENT_DATE_")
    @ApiModelProperty(value = "批复日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date establishmentDate=new Date();

//    @Excel(name = "审批单位")
    @TableField("ESTABLISHMENT_APPROVAL_UNIT_")
    @ApiModelProperty(value = "审批单位")
    private String establishmentApprovalUnit="";

    @Excel(name = "工程费用(万元)")
    @TableField("ENGINEERING_COST_")
    @ApiModelProperty(value = "工程费用(万元)")
    private String engineeringCost;

    @Excel(name = "预备费用(万元)")
    @TableField("RESERVE_COST_")
    @ApiModelProperty(value = "预备费用(万元)")
    private String reserveCost;

    @Excel(name = "建设其他费用(万元)")
    @TableField("ENGINEERING_OTHER_COST_")
    @ApiModelProperty(value = "建设其他费用(万元)")
    private String engineeringOtherCost;

    @Excel(name = "建设期贷款利息(万元)")
    @TableField("ESTABLISHMENT_NAME_")
    @ApiModelProperty(value = "建设期贷款利息（万元）")
    private String establishmentName;

    @Excel(name = "土地成本(万元)")
    @TableField("LAND_COST_")
    @ApiModelProperty(value = "土地成本(万元)")
    private String landCost;

//    @Excel(name = "总投资(万元)")
    @TableField("ESTABLISHMENT_INVESTMENT_AMOUNT_")
    @ApiModelProperty(value = "总投资(万元)，由上面所有费用求和所得")
    private String establishmentInvestmentAmount;

//    @Excel(name = "建设长度")
    @TableField("CONSTRUCTION_LENGTH_")
    @ApiModelProperty(value = "建设长度")
    private String constructionLength;

//    @Excel(name = "建设宽度")
    @TableField("CONSTRUCTION_WIDTH_")
    @ApiModelProperty(value = "建设宽度")
    private String constructionWidth;

//    @Excel(name = "建设面积")
    @TableField("CONSTRUCTION_HEIGHT_")
    @ApiModelProperty(value = "建设面积（单位：㎡）")
    private String constructionHeight;

//    @Excel(name = "建设规模和主要内容")
    @TableField("ESTABLISHMENT_SCALE_")
    @ApiModelProperty(value = "建设规模和主要内容")
    private String establishmentScale;

    @Excel(name = "备注")
    @TableField("ESTABLISHMENT_REMARKS_")
    @ApiModelProperty(value = "备注")
    private String establishmentRemarks;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件信息")
    private List<Accessory> accessoryInfo;

    /**
     * 获取主键值
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "FeasibilityStudyReply{" +
                "id='" + id + '\'' +
                ", projectId='" + projectId + '\'' +
                ", documentNumber='" + documentNumber + '\'' +
                ", establishmentName='" + establishmentName + '\'' +
                ", establishmentDate=" + establishmentDate +
                ", establishmentApprovalUnit='" + establishmentApprovalUnit + '\'' +
                ", engineeringCost='" + engineeringCost + '\'' +
                ", reserveCost='" + reserveCost + '\'' +
                ", landCost='" + landCost + '\'' +
                ", engineeringOtherCost='" + engineeringOtherCost + '\'' +
                ", establishmentInvestmentAmount='" + establishmentInvestmentAmount + '\'' +
                ", constructionLength='" + constructionLength + '\'' +
                ", constructionWidth='" + constructionWidth + '\'' +
                ", constructionHeight='" + constructionHeight + '\'' +
                ", establishmentScale='" + establishmentScale + '\'' +
                ", establishmentRemarks='" + establishmentRemarks + '\'' +
                ", projectInfo=" + projectInfo +
                ", accessoryInfo=" + accessoryInfo +
                '}';
    }
}

