package com.artfess.cqxy.completionAcceptance.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.completionAcceptance.model.AcceptanceFinalAccounts;
import org.apache.ibatis.annotations.Param;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * 竣工验收 - 决算表(BizAcceptanceFinalAccounts)表服务接口
 *
 * @author 黎沐华
 * @since 2022-03-07 15:52:29
 */
public interface AcceptanceFinalAccountsManager extends BaseManager<AcceptanceFinalAccounts> {

    boolean deleteByIds(List<String> ids);

    /**
     * 导入Excel数据
     * @param file 文件
     * @param projectId 项目ID
     */
    void importExcelData(MultipartFile file, String projectId, String contractId, String contractName);

    /**
     * 导出数据到Excel文件
     * @param queryFilter 通用查询器
     * @param response 响应对象
     * @throws IOException IO异常
     */
    void exportDataToExcel(QueryFilter<AcceptanceFinalAccounts> queryFilter, HttpServletResponse response) throws IOException;

    /**
     * 通过ID获取数据，关联项目信息，不能使用原生查询
     * @param id ID
     * @return 一条数据
     */
    AcceptanceFinalAccounts getById(@Param("id") String id);

    /**
     * 分页查询所有数据
     * @param queryFilter 通用查询器
     * @return 数据集合
     */
    PageList<AcceptanceFinalAccounts> queryAllByPage(QueryFilter<AcceptanceFinalAccounts> queryFilter);


    /**
     * 通过项目ID修改项目ID
     *
     * @param oldProjectIds
     * @param newProjectId
     *
     */
    void updateProjectIdByProiectId(String oldProjectIds, String newProjectId);
}

