package com.artfess.cqxy.completionAcceptance.dao;

import com.artfess.cqxy.completionAcceptance.model.AcceptanceDrawings;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

/**
 * 竣工验收 -  竣工图(AcceptanceDrawings)表数据库访问层
 *
 * @author 黎沐华
 * @since 2022-04-07 14:23:19
 */
public interface AcceptanceDrawingsDao extends BaseMapper<AcceptanceDrawings> {

    /**
     * 通过ID获取数据，关联项目信息，不能使用原生查询
     * @param id ID
     * @return 一条数据
     */
    AcceptanceDrawings getById(@Param("id") String id);

    /**
     * 分页查询所有数据
     * @param convert2IPage 分页对象
     * @param convert2Wrapper 查询参数
     * @return 数据集合
     */
    IPage<AcceptanceDrawings> queryAllByPage(IPage<AcceptanceDrawings> convert2IPage, @Param(Constants.WRAPPER) Wrapper<AcceptanceDrawings> convert2Wrapper);

}

