/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.job.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.context.BaseContext;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.job.model.JobDetails;
import com.artfess.job.model.SchedulerVo;
import com.artfess.job.model.SysJobLog;
import com.artfess.job.model.TriggerModel;
import com.artfess.job.persistence.manager.JobDetailsManager;
import com.artfess.job.persistence.manager.SchedulerService;
import com.artfess.job.persistence.manager.SysJobLogManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/job/scheduler/v1/"})
@Api(tags={"\u8c03\u5ea6\u4efb\u52a1"})
@ApiGroup(group={"group_application"})
public class SchedulerController
extends BaseController<SysJobLogManager, SysJobLog> {
    @Resource
    SchedulerService schedulerService;
    @Resource
    SysJobLogManager jobLogManager;
    @Resource
    JobDetailsManager jobDetailsManager;
    @Resource
    BaseContext baseContext;

    @RequestMapping(value={"addJob"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6dfb\u52a0\u4efb\u52a1", httpMethod="POST", notes="\u6dfb\u52a0\u4efb\u52a1")
    public CommonResult addJob(@ApiParam(name="scheduler", value="\u5b9e\u4f53\u5bf9\u8c61") @RequestBody SchedulerVo scheduler) throws Exception {
        boolean isExist = this.schedulerService.isJobExists(scheduler.getJobName());
        if (isExist) {
            return new CommonResult(false, "\u4efb\u52a1\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff0c\u6dfb\u52a0\u5931\u8d25", null);
        }
        if (this.isExist("className", scheduler.getClassName())) {
            return new CommonResult(false, "\u4efb\u52a1\u5217\u8868\u4e2d\u5df2\u6dfb\u52a0\u8be5\u4efb\u52a1\u7c7b\u8bb0\u5f55\uff0c\u4e0d\u80fd\u591a\u6b21\u6dfb\u52a0\u540c\u4e00\u4efb\u52a1\u7c7b\uff01", null);
        }
        boolean isSuccess = this.schedulerService.addJob(scheduler.getJobName(), scheduler.getClassName(), scheduler.getParameterJson(), scheduler.getDescription());
        if (!isSuccess) {
            return new CommonResult(false, "\u4efb\u52a1\u6dfb\u52a0\u5931\u8d25(\u53ef\u80fd\u662f\u4efb\u52a1\u7c7b\u4e0d\u5b58\u5728\u6216\u5c5e\u6027\u7c7b\u578b\u3001\u503c\u4e0d\u4e00\u81f4!", null);
        }
        return new CommonResult(true, "\u6dfb\u52a0\u4efb\u52a1\u6210\u529f", null);
    }

    @RequestMapping(value={"saveJob"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u4efb\u52a1", httpMethod="POST", notes="\u6dfb\u52a0\u4efb\u52a1")
    public CommonResult saveJob(@ApiParam(name="scheduler", value="\u5b9e\u4f53\u5bf9\u8c61") @RequestBody SchedulerVo scheduler, @ApiParam(name="scheduler", value="\u5b9e\u4f53\u5bf9\u8c61") @RequestParam String jobName) throws Exception {
        boolean isExist;
        if (!jobName.equals(scheduler.getJobName()) && (isExist = this.schedulerService.isJobExists(scheduler.getJobName()))) {
            return new CommonResult(false, "\u4efb\u52a1\u540d\u79f0\u3010" + scheduler.getJobName() + "\u3011\u5df2\u7ecf\u5b58\u5728\uff0c\u66f4\u65b0\u5931\u8d25", null);
        }
        boolean isSuccess = this.schedulerService.addJob(scheduler.getJobName(), scheduler.getClassName(), scheduler.getParameterJson(), scheduler.getDescription());
        if (!isSuccess) {
            return new CommonResult(false, "\u4efb\u52a1\u4fdd\u5b58\u5931\u8d25(\u53ef\u80fd\u662f\u4efb\u52a1\u7c7b\u4e0d\u5b58\u5728\u6216\u5c5e\u6027\u7c7b\u578b\u3001\u503c\u4e0d\u4e00\u81f4!", null);
        }
        return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f", null);
    }

    @RequestMapping(value={"jobList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u4efb\u52a1\u5217\u8868")
    public PageList<JobDetails> jobList(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<JobDetails> queryFilter) throws Exception {
        queryFilter.addFilter("jobGroup", (Object)this.baseContext.getCurrentTenantId(), QueryOP.EQUAL);
        return this.jobDetailsManager.query(queryFilter);
    }

    @RequestMapping(value={"getStand"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5b9a\u65f6\u5668\u72b6\u6001", httpMethod="GET", notes="\u83b7\u53d6\u5b9a\u65f6\u5668\u72b6\u6001")
    public boolean getStand() throws Exception {
        boolean inStandbyMode = this.schedulerService.isInStandbyMode();
        return !inStandbyMode;
    }

    @RequestMapping(value={"schedulerJobJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5b9a\u65f6\u5668\u4efb\u52a1\u5217\u8868", httpMethod="GET", notes="\u83b7\u53d6\u5b9a\u65f6\u5668\u4efb\u52a1\u5217\u8868")
    public List<SchedulerVo> schedulerJobJson() throws Exception {
        List<SchedulerVo> list = this.schedulerService.getJobList();
        return list;
    }

    @RequestMapping(value={"delJob"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u4efb\u52a1", httpMethod="DELETE", notes="\u5220\u9664\u4efb\u52a1")
    public CommonResult delJob(@ApiParam(name="jobName", value="\u4efb\u52a1\u540d\u79f0", required=true) @RequestParam String jobName) throws Exception {
        try {
            this.schedulerService.delJob(jobName);
            return new CommonResult(true, "\u5220\u9664\u6210\u529f", null);
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5220\u9664\u5931\u8d25", null);
        }
    }

    @RequestMapping(value={"addTrigger"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6dfb\u52a0\u8ba1\u5212", httpMethod="POST", notes="\u6dfb\u52a0\u8ba1\u5212")
    public CommonResult addTrigger(@ApiParam(name="triggerModel", value="\u5b9a\u65f6\u8ba1\u5212") @RequestBody TriggerModel triggerModel) throws Exception {
        boolean rtn = this.schedulerService.isTriggerExists(triggerModel.getTriggerName());
        if (rtn) {
            return new CommonResult(false, "\u6307\u5b9a\u7684\u8ba1\u5212\u540d\u79f0\u5df2\u7ecf\u5b58\u5728!", null);
        }
        try {
            this.schedulerService.addTrigger(triggerModel.getJobName(), triggerModel.getTriggerName(), triggerModel.getDescription());
            return new CommonResult(true, "\u6dfb\u52a0\u8ba1\u5212\u6210\u529f", null);
        }
        catch (SchedulerException e) {
            e.printStackTrace();
            return new CommonResult(false, "\u6dfb\u52a0\u8ba1\u5212\u5931\u8d25", null);
        }
    }

    @RequestMapping(value={"getTriggersJsonByJob"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u5f97\u89e6\u53d1\u5668\u5b9e\u4f53", httpMethod="POST", notes="\u83b7\u5f97\u89e6\u53d1\u5668\u5b9e\u4f53")
    public List<TriggerModel> getTriggersJsonByJob(@ApiParam(name="jobName", value="\u8ba1\u5212\u540d\u79f0", required=true) @RequestParam String jobName) throws SchedulerException {
        List<Trigger> list = this.schedulerService.getTriggersByJob(jobName);
        HashMap<String, Trigger.TriggerState> mapState = this.schedulerService.getTriggerStatus(list);
        ArrayList<TriggerModel> modelList = new ArrayList<TriggerModel>();
        for (Trigger trigger : list) {
            String trigName = trigger.getKey().getName();
            TriggerModel model = new TriggerModel();
            model.setJobName(trigger.getJobKey().getName());
            model.setTriggerName(trigName);
            model.setDescription(trigger.getDescription());
            Trigger.TriggerState state = mapState.get(trigName);
            model.setState(state.name());
            modelList.add(model);
        }
        return modelList;
    }

    @RequestMapping(value={"executeJob"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6267\u884c\u4efb\u52a1", httpMethod="POST", notes="\u6267\u884c\u4efb\u52a1")
    public CommonResult executeJob(@ApiParam(name="jobName", value="\u8ba1\u5212\u540d\u79f0", required=true) @RequestParam String jobName) throws Exception {
        try {
            this.schedulerService.executeJob(jobName);
            return new CommonResult(true, "\u6267\u884c\u4efb\u52a1\u6210\u529f!", null);
        }
        catch (Exception ex) {
            return new CommonResult(false, "\u6267\u884c\u4efb\u52a1\u5931\u8d25!", null);
        }
    }

    @RequestMapping(value={"validClass"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9a8c\u8bc1\u7c7b", httpMethod="GET", notes="\u9a8c\u8bc1\u7c7b")
    public CommonResult validClass(@ApiParam(name="className", value="\u7c7b\u540d", required=true) @RequestParam String className) throws Exception {
        boolean rtn = BeanUtils.validClass((String)className);
        if (rtn) {
            return new CommonResult(true, "\u9a8c\u8bc1\u7c7b\u6210\u529f!", null);
        }
        return new CommonResult(false, "\u9a8c\u8bc1\u7c7b\u5931\u8d25!", null);
    }

    @RequestMapping(value={"delTrigger"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u89e6\u53d1\u5668", httpMethod="DELETE", notes="\u5220\u9664\u89e6\u53d1\u5668")
    public CommonResult delTrigger(@ApiParam(name="name", value="\u89e6\u53d1\u5668\u540d\u79f0", required=true) @RequestParam String name) throws Exception {
        try {
            this.schedulerService.delTrigger(name);
            return new CommonResult(true, "\u5220\u9664\u8ba1\u5212\u6210\u529f!", null);
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5220\u9664\u8ba1\u5212\u5931\u8d25!", null);
        }
    }

    @RequestMapping(value={"toggleTriggerRun"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u542f\u7528\u6216\u7981\u7528", httpMethod="POST", notes="\u542f\u7528\u6216\u7981\u7528")
    public CommonResult toggleTriggerRun(@ApiParam(name="name", value="\u89e6\u53d1\u5668\u540d\u79f0", required=true) @RequestParam String name) throws Exception {
        try {
            this.schedulerService.toggleTriggerRun(name);
            return new CommonResult(true, "\u6210\u529f!", null);
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5931\u8d25!", null);
        }
    }

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u6267\u884c\u65e5\u5fd7\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u4efb\u52a1\u6267\u884c\u65e5\u5fd7\u5217\u8868")
    public PageList<SysJobLog> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter, @ApiParam(name="jobName", value="\u4efb\u52a1\u540d\u79f0") @RequestParam String jobName, @ApiParam(name="trigName", value="\u89e6\u53d1\u5668\u540d") @RequestParam String trigName) throws Exception {
        if (!"".equals(jobName) && jobName != null) {
            queryFilter.addFilter("job_Name_", (Object)jobName, QueryOP.EQUAL);
        }
        if (!"".equals(trigName) && trigName != null) {
            queryFilter.addFilter("trig_Name_", (Object)trigName, QueryOP.EQUAL);
        }
        return this.jobLogManager.query(queryFilter);
    }

    @RequestMapping(value={"delJobLog"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u4efb\u52a1\u65e5\u5fd7", httpMethod="DELETE", notes="\u5220\u9664\u4efb\u52a1\u65e5\u5fd7")
    public CommonResult del(@ApiParam(name="id", value="\u65e5\u5fd7id", required=true) @RequestParam String ids) throws Exception {
        try {
            String[] aryIds = StringUtil.getStringAryByStr((String)ids);
            List<String> idList = Arrays.asList(aryIds);
            this.jobLogManager.removeByIds(idList);
            return new CommonResult(true, "\u5220\u9664\u4efb\u52a1\u65e5\u5fd7\u6210\u529f", null);
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5220\u9664\u4efb\u52a1\u65e5\u5fd7\u5931\u8d25", null);
        }
    }

    @RequestMapping(value={"changeStart"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fee\u6539\u5b9a\u65f6\u5668\u7684\u72b6\u6001", httpMethod="POST", notes="\u4fee\u6539\u5b9a\u65f6\u5668\u7684\u72b6\u6001")
    public CommonResult changeStart(@ApiParam(name="isStandby", value="\u6302\u8d77\u72b6\u6001", required=true) @RequestParam Boolean isStandby) throws Exception {
        String message = null;
        try {
            if (isStandby.booleanValue()) {
                this.schedulerService.start();
                message = "\u542f\u52a8\u5b9a\u65f6\u5668\u6210\u529f\uff01";
                boolean inStandbyMode = this.schedulerService.isInStandbyMode();
                System.out.println(inStandbyMode);
            } else {
                this.schedulerService.shutdown();
                boolean f = this.schedulerService.isInStandbyMode();
                message = "\u505c\u6b62\u5b9a\u65f6\u5668\u6210\u529f!";
            }
            return new CommonResult(true, message, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            message = isStandby != false ? "\u542f\u52a8\u5b9a\u65f6\u5668\u5931\u8d25:" : "\u505c\u6b62\u5b9a\u65f6\u5668\u5931\u8d25:";
            return new CommonResult(false, message, null);
        }
    }

    @RequestMapping(value={"isExist"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u662f\u5426\u5b58\u5728", httpMethod="GET", notes="\u662f\u5426\u5b58\u5728")
    public boolean isExist(@ApiParam(name="name", value="\u540d\u79f0", required=true) @RequestParam String name, @ApiParam(name="type", value="\u7c7b\u578b", required=true) @RequestParam String type) throws Exception {
        boolean isExist;
        block5: {
            isExist = false;
            try {
                if ("className".equals(type)) {
                    List<SchedulerVo> list = this.schedulerService.getJobList();
                    if (!BeanUtils.isNotEmpty(list)) break block5;
                    for (SchedulerVo job : list) {
                        String className = job.getClassName();
                        if (!name.equals(className)) continue;
                        isExist = true;
                        break block5;
                    }
                    break block5;
                }
                if ("jobName".equals(type)) {
                    isExist = this.schedulerService.isJobExists(name);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return isExist;
    }

    @RequestMapping(value={"getJobDetail"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5b9a\u65f6\u8ba1\u5212\u660e\u7ec6", httpMethod="GET", notes="\u83b7\u53d6\u5b9a\u65f6\u8ba1\u5212\u660e\u7ec6")
    public SchedulerVo getJobDetail(@ApiParam(name="name", value="\u8ba1\u5212\u540d\u79f0", required=true) @RequestParam String name) throws Exception {
        return this.schedulerService.getJobDetail(name);
    }
}

