/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.utils;

import com.artfess.uc.exception.BaseException;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadUtil {
    private static final int TASK_SIZE_1 = 20;
    private static final int TASK_SIZE_2 = 40;
    private static final int TASK_SIZE_3 = 80;
    private static final int TASK_SIZE_4 = 160;
    private static final int QUEUE_DEFAULT_WAIT_TIME = 30;
    public static ExecutorService publicPool;

    public static int getCoreNum() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static int getExpectThreadNum(int taskNum) {
        int coreNum = ThreadUtil.getCoreNum();
        if (taskNum <= 0) {
            throw new BaseException("\u591a\u7ebf\u7a0b\u521d\u59cb\u5316\u5f02\u5e38: \u4efb\u52a1\u6570\u91cf\u4e3a0");
        }
        if (taskNum == 1) {
            return 1;
        }
        if (taskNum <= 20) {
            return Math.min(coreNum, 2);
        }
        if (taskNum <= 40) {
            return Math.min(coreNum, 4);
        }
        if (taskNum <= 80) {
            return Math.min(coreNum, 6);
        }
        if (taskNum <= 160) {
            return Math.min(coreNum, 8);
        }
        return coreNum <= 8 ? coreNum : (coreNum <= 16 ? coreNum - 4 : 16);
    }

    public static int getThreadTaskNum(int threadNum, int taskNum) {
        if (threadNum > taskNum) {
            throw new BaseException("\u591a\u7ebf\u7a0b\u521d\u59cb\u5316\u5f02\u5e38: \u7ebf\u7a0b\u6570>\u4efb\u52a1\u6570");
        }
        return taskNum / threadNum;
    }

    public static void sleepBeforeAutoTask(int secondsBound) {
        secondsBound = secondsBound <= 0 ? 1800 : secondsBound;
        Random random = new Random();
        int i = random.nextInt(secondsBound) + 1;
        try {
            TimeUnit.SECONDS.sleep(i);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void sleepBeforeAutoTask() {
        Random random = new Random();
        int i = random.nextInt(1800) + 1;
        try {
            TimeUnit.SECONDS.sleep(i);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    static {
        int poolSize = ThreadUtil.getCoreNum() * 2;
        int maxPoolSize = poolSize * 2;
        publicPool = new ThreadPoolExecutor(poolSize, maxPoolSize, 30L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(maxPoolSize), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
    }
}

