package com.artfess.cqxy.ledger.vo;

import com.artfess.cqxy.contract.model.Contract;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

import java.util.Date;
import java.util.List;

/**
 * @author Limuhua
 * @date 2022/3/18 9:19
 */
@Data
public class ContractLedgerVo {

    // 合同表
    @ApiModelProperty(value = "项目ID")
    private String projectId;

    @ApiModelProperty(value = "合同ID")
    private String contractId;

    @ApiModelProperty(value = "合同编号")
    private String contractNumber;

    @ApiModelProperty(value = "合同名称")
    private String name;

    @ApiModelProperty(value = "合同类别，（使用字典，G1：施工合同，G2：抢修整治，G3：补充协议，J1：安全影响评估，J2：白蚁合同，J3：洪水影响评估，J4：编制项目咨询合同，J5：代理合同，J6：地址灾害危险性评估合同，J7：方案报告编制合同，J8：防雷装置安全监测监测合同，J9：工程概算审核，J10：工程概算审核表，J11：工程质量检测合同，J12：官网内窥监测合同，J13：规划设计合同，J14：规划咨询合同，J15：洪水影响评价合同，J16：环境检测影响评价合同，J17：环境检测服务合同，J18：技术服务合同，J19：监理合同，J20：勘察合同，J21：检测合同，J22：勘察设计合同，J23：勘察外业见证合同，J24：勘察文件审核合同，J25：桥荷载试验合同，J26：设计合同，J27：设计补充协议，J28：审查合同，J29：施工图设计合同，J30：施工图设计文件审核合同，J31：试验监测技术服务合同，J32：消防设施监测合同，J33：续签合同，J34：预算编制合同，J35：预算审核合同，J36：造价咨询合同，J37：造价审核合同，J38：招标代理合同，J39：资产评估委托合同，J40：质量监测合同，J41：咨询合同，F1：安全管理协议，F2：机械设备租赁服务合同，F3：应急救援协议，F4：咨询服务合同，C1：采购合同，P1：安全保护协议，P2：电费结算协议，P3：工程合同，P4：技术咨询合同，P5：监理合同，P6：临时供用电合同，P7：施工合同，P8：占绿补偿，1：其他）")
    private String type;

    @ApiModelProperty(value = "合同类别值，（合同类型下拉选择后的中文值）")
    private String typeValue;

    @ApiModelProperty(value = "签订日期")
    private String contractDate;


    @ApiModelProperty(value = "合同金额（万元）")
    private String contractAmount;

    @ApiModelProperty(value = "决策依据")
    private String decisionDocuments;


    @ApiModelProperty(value = "合同涉及事项，（默认为项目名称）")
    private String contractInvolved;

    @ApiModelProperty(value = "合同分类，（使用字典，1：G-工程类，2：J-技术类合同，3：F-服务类合同，4：C-采购类合同，5：P-配套类合同，6：其他）")
    private String mold;

    @ApiModelProperty(value = "合同分类值，（合同分类下拉选择后的中文值）")
    private String moleValue;

    @ApiModelProperty(value = "甲方")
    private String firstParty;

    @ApiModelProperty(value = "乙方单位")
    private String secondParty;

    @ApiModelProperty(value = "第三方")
    private String thirdParty;

    @ApiModelProperty(value = "唯一编号，（由后端生成，按照年月+0000001 自增方式）")
    private String uniqueNumber;

    @ApiModelProperty(value = "合同异常记录")
    private String contractExceptionLog;

    @ApiModelProperty(value = "合同执行进度")
    private String contractSchedule;

    @ApiModelProperty(value = "留存份数")
    private Integer contractCopsNum;

    @ApiModelProperty(value = "保证金")
    private String retentionMoney;

    @ApiModelProperty(value = "合同约定付款方式")
    private String treatyContents;

    @ApiModelProperty(value = "约定完成日期")
    private String endDate;

    @ApiModelProperty(value = "合同领取人")
    private String contractKeeper;

    @ApiModelProperty(value = "合同存放处")
    private String contractStorage;

    @ApiModelProperty(value = "合同经办人）")
    private String contractReceiver;

    @ApiModelProperty(value = "收款人及账号、电话")
    private String payeeAccountPhone;

    @ApiModelProperty(value = "收款人")
    private String payee;

    @ApiModelProperty(value = "收款人账号")
    private String payeeAccount;

    @ApiModelProperty(value = "开户行")
    private String payeeContactPhone;

    @ApiModelProperty(value = "二级分类")
    private String secondLevelType;

    @ApiModelProperty(value = "招标方式，（使用字典：1：公开招标，2：直接委托，3：走流程，4其他）")
    private String biddingChargeType;

    @ApiModelProperty(value = "我方主体 / 甲方")
    private String ourPart;

    @ApiModelProperty(value = "其他相对方主体 / 乙方+第三方")
    private String otherPart;



    @ApiModelProperty(value = "已支付金额")
    private String amountAppropriated;

    @ApiModelProperty(value = "剩余金额")
    private String remainingAmount;

    @ApiModelProperty(value = "支付比例")
    private String ratioAmount;


    @ApiModelProperty(value = "备注")
    private String establishmentRemarks;

    // 项目表
    @ApiModelProperty(value = "经办人 / 项目负责人")
    private String agent;
    @ApiModelProperty("项目代码")
    private String projectCode;
    @ApiModelProperty("项目名")
    private String projectName;

    public ContractLedgerVo() {
    }

    public static ContractLedgerVo contractToVo(Contract data, List<DictModel> bidType){
        ContractLedgerVo temp = new ContractLedgerVo();
        BeanUtils.copyProperties(data, temp);
        temp.setContractId(BizUtils.handleStringFormat(data.getId()));
        temp.setContractNumber(BizUtils.handleStringFormat(data.getContractNumber()));
        temp.setName(BizUtils.handleStringFormat(data.getName()));
        temp.setSecondLevelType(BizUtils.handleStringFormat(data.getSecondLevelType()));
        temp.setBiddingChargeType(BizUtils.handleStringFormat(BizUtils.getDicValueByCode(bidType, data.getBiddingChargeType())));
        temp.setDecisionDocuments(BizUtils.handleStringFormat(data.getDecisionDocuments()));
        temp.setContractInvolved(BizUtils.handleStringFormat(data.getContractInvolved()));
//        temp.setType(BizUtils.handleStringFormat(BizUtils.getDicValueByCode(contractType, data.getType())));
        temp.setType(BizUtils.handleStringFormat(data.getTypeValue()));
        temp.setOurPart(BizUtils.handleStringFormat(data.getFirstParty()));
        String otherPart = "";
        boolean hasOneEmpty = StringUtils.isEmpty(data.getSecondParty())||StringUtils.isEmpty(data.getThirdParty());
        if (hasOneEmpty){
            otherPart = BizUtils.handleStringFormat(data.getSecondParty())+BizUtils.handleStringFormat(data.getThirdParty());
        }else if(!hasOneEmpty){
            otherPart = BizUtils.handleStringFormat(data.getSecondParty())+"，"+BizUtils.handleStringFormat(data.getThirdParty());
        }
        temp.setOtherPart(otherPart);
        temp.setContractDate(BizUtils.handleDateFormat(data.getContractDate()));
        temp.setEndDate(BizUtils.handleDateFormat(data.getEndDate()));
        temp.setContractAmount(data.getContractAmount());
        temp.setContractExceptionLog(BizUtils.handleStringFormat(data.getContractExceptionLog()));
        temp.setContractSchedule(BizUtils.handleStringFormat(data.getContractSchedule()));
        temp.setContractCopsNum(data.getContractCopsNum());
        temp.setRetentionMoney(BizUtils.handleStringFormat(data.getRetentionMoney()));
        temp.setContractKeeper(BizUtils.handleStringFormat(data.getContractKeeper()));
        temp.setContractStorage(BizUtils.handleStringFormat(data.getContractStorage()));
        temp.setContractReceiver(BizUtils.handleStringFormat(data.getContractReceiver()));
        temp.setEstablishmentRemarks(BizUtils.handleStringFormat(data.getEstablishmentRemarks()));
        return temp;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Override
    public String toString() {
        return "ContractLedgerVo{" +
                "contractId='" + contractId + '\'' +
                ", contractNumber='" + contractNumber + '\'' +
                ", name='" + name + '\'' +
                ", secondLevelType='" + secondLevelType + '\'' +
                ", biddingChargeType='" + biddingChargeType + '\'' +
                ", decisionDocuments='" + decisionDocuments + '\'' +
                ", contractInvolved='" + contractInvolved + '\'' +
                ", type='" + type + '\'' +
                ", ourPart='" + ourPart + '\'' +
                ", otherPart='" + otherPart + '\'' +
                ", contractDate='" + contractDate + '\'' +
                ", endDate='" + endDate + '\'' +
                ", contractAmount='" + contractAmount + '\'' +
                ", amountAppropriated='" + amountAppropriated + '\'' +
                ", remainingAmount='" + remainingAmount + '\'' +
                ", ratioAmount='" + ratioAmount + '\'' +
                ", contractExceptionLog='" + contractExceptionLog + '\'' +
                ", contractSchedule='" + contractSchedule + '\'' +
                ", contractCopsNum=" + contractCopsNum +
                ", retentionMoney='" + retentionMoney + '\'' +
                ", contractKeeper='" + contractKeeper + '\'' +
                ", contractStorage='" + contractStorage + '\'' +
                ", contractReceiver='" + contractReceiver + '\'' +
                ", establishmentRemarks='" + establishmentRemarks + '\'' +
                ", agent='" + agent + '\'' +
                ", projectCode='" + projectCode + '\'' +
                ", projectName='" + projectName + '\'' +
                '}';
    }
}
