package com.artfess.cqxy.designEstimate.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.designEstimate.model.AquaticProtection;
import com.artfess.cqxy.designEstimate.model.Estimate;
import com.artfess.cqxy.projectApproval.model.DecisionBasis;
import org.apache.ibatis.annotations.Param;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 设计概算 - 概算表(BizEstimate)表服务接口
 * @author 黎沐华
 * @since 2022-02-15 17:29:48
 */
public interface EstimateManager extends BaseManager<Estimate> {

    /**
     * 导入Excel数据
     * @param file 文件
     * @param projectId 项目ID
     */
    void importExcelData(MultipartFile file, String projectId);

    boolean deleteByIds(List<String> ids);

    /**
     * 导出数据到Excel文件
     * @param queryFilter 通用查询器
     * @param response 响应对象
     * @throws IOException IO异常
     */
    void exportDatatoExcel(QueryFilter<Estimate> queryFilter, HttpServletResponse response) throws IOException;

    /**
     * 通过ID获取数据，关联项目信息，不能使用原生查询
     * @param id ID
     * @return 一条数据
     */
    Estimate getById(@Param("id") String id);

    /**
     * 分页查询所有数据
     * @param queryFilter 通用查询器
     * @return 数据集合
     */
    PageList<Estimate> queryAllByPage(QueryFilter<Estimate> queryFilter);

    /**
     * 通过项目ID修改项目ID
     *
     * @param oldProjectIds
     * @param newProjectId
     *
     */
    void updateProjectIdByProiectId(String oldProjectIds, String newProjectId);

    BigDecimal getEstimate(String pid, String year);
}

