package com.artfess.cqxy.completionAcceptance.model;


import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import com.artfess.base.entity.BizModel;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 竣工验收 - 联合备案验收表(BizRecordAcceptance)表实体类
 *
 * @author 黎沐华
 * @since 2022-03-07 14:28:02
 */
@Data
@TableName("biz_record_acceptance")
@ApiModel(value = "竣工验收-联合验收及备案对象-RecordAcceptance", description = "联合验收及备案表")
public class RecordAcceptance extends BizModel<RecordAcceptance> {

    // 关联项目的信息放在开头，以便在导出时先导出项目中的配置，而不用进行额外的位置配置
    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的项目信息")
    private ProjectManagement projectInfo;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID（关联项目管理表ID）")
    private String projectId;

    @Excel(name = "竣工验收日期", format = "yyyy-MM-dd")
    @TableField("COMPLETION_ACCEPTANCE_DATE_")
    @ApiModelProperty(value = "竣工验收日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date completionAcceptanceDate;

    @Excel(name = "备案机关审批单位")
    @TableField("APPROVAL_UNIT_FILING_AUTHORITY_")
    @ApiModelProperty(value = "备案机关审批单位")
    private String approvalUnitFilingAuthority;

    @Excel(name = "备案机关审批日期", format = "yyyy-MM-dd")
    @TableField("APPROVAL_FILING_AUTHORITY_DATE_")
    @ApiModelProperty(value = "备案机关审批日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date approvalFilingAuthorityDate;

    @Excel(name = "竣工验收意见")
    @TableField("COMPLETION_ACCEPTANCE_OPINIONS_")
    @ApiModelProperty(value = "竣工验收意见")
    private String completionAcceptanceOpinions;

    @Excel(name = "竣工验收备案登记人")
    @TableField("COMPLETION_ACCEPTANCE_REGISTRANT_")
    @ApiModelProperty(value = "竣工验收备案登记人")
    private String completionAcceptanceRegistrant;

    @Excel(name = "备注")
    @TableField("REMARKS_")
    @ApiModelProperty(value = "备注")
    private String remarks;

    //    @Excel(name = "文号")
    @TableField("DOCUMENT_NUMBER_")
    @ApiModelProperty(value = "文号")
    private String documentNumber;

    //    @Excel(name = "联合备案验收名称")
    @TableField("NAME_")
    @ApiModelProperty(value = "名称")
    private String name;

    //    @Excel(name = "工程名称")
    @TableField("COMPLETION_PROJECT_NAME_")
    @ApiModelProperty(value = "工程名称（与项目名称相同，选择项目后自动填入）")
    private String completionProjectName;

    //    @Excel(name = "备案机关审批人")
    @TableField("APPROVAL_FILING_AUTHORITY_")
    @ApiModelProperty(value = "备案机关审批人")
    private String approvalFilingAuthority;

    //    @Excel(name = "备案机关审批意见")
    @TableField("APPROVAL_OPINION_")
    @ApiModelProperty(value = "备案机关审批意见")
    private String approvalOpinion;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件信息")
    private List<Accessory> accessoryInfo;

    /**
     * 获取主键值
     *
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "RecordAcceptance{" +
                "id='" + id + '\'' +
                ", projectId='" + projectId + '\'' +
                ", completionProjectName='" + completionProjectName + '\'' +
                ", completionAcceptanceOpinions='" + completionAcceptanceOpinions + '\'' +
                ", completionAcceptanceRegistrant='" + completionAcceptanceRegistrant + '\'' +
                ", completionAcceptanceDate=" + completionAcceptanceDate +
                ", approvalUnitFilingAuthority='" + approvalUnitFilingAuthority + '\'' +
                ", approvalFilingAuthority='" + approvalFilingAuthority + '\'' +
                ", approvalFilingAuthorityDate=" + approvalFilingAuthorityDate +
                ", approvalOpinion='" + approvalOpinion + '\'' +
                ", remarks='" + remarks + '\'' +
                ", projectInfo=" + projectInfo +
                ", accessoryInfo=" + accessoryInfo +
                '}';
    }
}

