/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.contract.manager.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.DateUtils;
import com.artfess.cqxy.contract.dao.FundPlanDao;
import com.artfess.cqxy.contract.manager.FundPlanManager;
import com.artfess.cqxy.contract.model.FundPlan;
import com.artfess.cqxy.processManagermant.manager.ProgressManageManager;
import com.artfess.cqxy.processManagermant.model.ProgressManage;
import com.artfess.cqxy.projectManagement.enums.ProjectStatusEnum;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.search.enums.FunctionEnum;
import com.artfess.cqxy.search.manager.GlobalRetrievalManager;
import com.artfess.cqxy.search.model.GlobalRetrieval;
import com.artfess.cqxy.universal.manager.AccessoryManager;
import com.artfess.cqxy.universal.model.Accessory;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FundPlanManagerImpl
extends BaseManagerImpl<FundPlanDao, FundPlan>
implements FundPlanManager {
    @Autowired
    private AccessoryManager accessoryManager;
    @Autowired
    private ProjectManagementManager pm;
    @Autowired
    private SysDictionaryManager sdm;
    @Autowired
    private BaseContext baseContext;
    @Autowired
    private GlobalRetrievalManager grm;
    @Autowired
    private ProgressManageManager pgm;

    public boolean saveOrUpdate(FundPlan entity) {
        boolean save = StringUtils.isEmpty((CharSequence)entity.getId());
        boolean savedMain = super.saveOrUpdate((Object)entity);
        ArrayList<Accessory> flag = entity.getAccessoryInfo();
        ArrayList<Accessory> accessoryList = null == flag ? new ArrayList<Accessory>() : flag;
        for (Accessory ele : accessoryList) {
            ele.setSourceId(entity.getId());
            ele.setProjectId(entity.getProjectId());
            ele.setDirectory(ProjectStatusEnum.nine.getCode());
            ele.setGroup("FundPlan");
            ele.setNode(ProjectStatusEnum.nine.getCode());
            ele.setCreateBy(this.baseContext.getCurrentUserId());
            ele.setCreateName(this.baseContext.getCurrentUserName());
            ele.setCreateTime(LocalDateTime.now());
        }
        this.accessoryManager.removeBySourceId(entity.getId());
        boolean saveAcc = accessoryList.size() == 0 || this.accessoryManager.saveAccess(accessoryList);
        this.pm.updateStatusById(entity.getProjectId(), Integer.valueOf(ProjectStatusEnum.nine.getCode()));
        GlobalRetrieval globalRetrieval = this.grm.getByBizId(entity.getId());
        this.handleRetrieval(save || BeanUtils.isEmpty((Object)((Object)globalRetrieval)) ? new GlobalRetrieval() : globalRetrieval, entity);
        return savedMain && saveAcc;
    }

    private void handleRetrieval(GlobalRetrieval globalRetrieval, FundPlan entity) {
        ProjectManagement projectManagement = (ProjectManagement)((Object)this.pm.getById((Serializable)((Object)entity.getProjectId())));
        globalRetrieval.setProjectId(entity.getProjectId());
        globalRetrieval.setProjectName(projectManagement.getProjectName());
        globalRetrieval.setPersonCharge(projectManagement.getProjectManager());
        globalRetrieval.setArchivesType(1);
        globalRetrieval.setBizDataId(entity.getId());
        globalRetrieval.setFunctionCode(FunctionEnum.thirtyFive.getCode());
        globalRetrieval.setFunctionName(FunctionEnum.thirtyFive.getName());
        globalRetrieval.setBizTableName(FunctionEnum.thirtyFive.getTableName());
        globalRetrieval.setDetailsRoteUrl(FunctionEnum.thirtyFive.getTableRoteUrl());
        globalRetrieval.setTableRoteUrl(FunctionEnum.thirtyFive.getTableRoteUrl());
        globalRetrieval.setTableApiUrl(FunctionEnum.thirtyFive.getTableApiUrl());
        globalRetrieval.setDetailsApiUrl(FunctionEnum.thirtyFive.getDetailsApiUrl());
        globalRetrieval.setFunctionPath(FunctionEnum.thirtyFive.getFunctionPath());
        globalRetrieval.setName(entity.getPurpose());
        globalRetrieval.setSearchTitle(entity.getPurpose() + "_" + entity.getUnitNname() + "_" + entity.getRemarks());
        this.grm.saveOrUpdate((Object)globalRetrieval);
    }

    @Override
    public boolean deleteByIds(List<String> ids) {
        for (String ele : ids) {
            this.grm.remove(1, ele);
        }
        return this.removeByIds(ids);
    }

    @Override
    public FundPlan getById(String id) {
        FundPlan result = ((FundPlanDao)this.baseMapper).getById(id);
        result.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(id));
        return result;
    }

    @Override
    public PageList<FundPlan> queryAllByPage(QueryFilter<FundPlan> queryFilter) {
        BizUtils.handleFilter(queryFilter, "bfp", false);
        IPage<FundPlan> result = ((FundPlanDao)this.baseMapper).queryAllByPage((IPage<FundPlan>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<FundPlan>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        for (FundPlan ele : records) {
            ele.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(ele.getId()));
        }
        return new PageList(result);
    }

    @Override
    public void importExcelData(MultipartFile file, String projectId, String contractId) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)contractId, (String)"\u5408\u540cID\u4e0d\u80fd\u4e3a\u7a7a");
        try (InputStream inputStream = file.getInputStream();){
            List data = ExcelImportUtil.importExcel((InputStream)inputStream, FundPlan.class, (ImportParams)new ImportParams());
            for (FundPlan ele : data) {
                ele.setProjectId(projectId);
                ele.setContractId(contractId);
                this.save((Object)ele);
                this.handleRetrieval(new GlobalRetrieval(), ele);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exportDatatoExcel(QueryFilter<FundPlan> queryFilter, HttpServletResponse response) throws IOException {
        String fileName = "\u5408\u540c\u7ba1\u7406-\u8d44\u91d1\u8ba1\u5212-\u5bfc\u51fa\u7ed3\u679c";
        List checkType = this.sdm.queryDictListItemsByCode("jdgl-yt");
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(fileName);
        HSSFRow titleRow = sheet.createRow(0);
        BizUtils.handelCell(workbook, fileName, titleRow.createCell(0), "\u8d44\u91d1\u8ba1\u5212\u8868", true);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 8));
        ArrayList<String> heards = new ArrayList<String>();
        heards.addAll(Arrays.asList("\u5e8f\u53f7", "\u9879\u76ee\u540d\u79f0", "\u5408\u540cID", "\u5408\u540c\u540d\u79f0", "\u8ba1\u5212\u65e5\u671f", "\u8d39\u7528\u540d\u79f0", "\u5355\u4f4d\u540d\u79f0", "\u91d1\u989d", "\u662f\u54262022\u5e74\u65b0\u5f00\u5de5\u9879\u76ee", "\u662f\u54262022\u5e74\u4e13\u9879\u503a\u7533\u62a5\u9879\u76ee", "\u5907\u6ce8"));
        titleRow = sheet.createRow(1);
        for (int i = 0; i < heards.size(); ++i) {
            BizUtils.handelCell(workbook, fileName, titleRow.createCell(i), (String)heards.get(i), new boolean[0]);
        }
        int row = 2;
        BizUtils.handleFilter(queryFilter, "bfp", false);
        List data = ((FundPlanDao)this.baseMapper).queryAllByPage((IPage<FundPlan>)this.convert2IPage(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false))), (Wrapper<FundPlan>)this.convert2Wrapper(queryFilter, this.currentModelClass())).getRecords();
        if (null == data || data.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u8981\u5bfc\u51fa\u7684\u7684\u6570\u636e\uff01");
        }
        for (FundPlan fp : data) {
            fp.setPurpose(BizUtils.getDicValueByCode((List<DictModel>)checkType, fp.getPurpose()));
        }
        int counter = 1;
        this.exportToExcel(data, workbook, sheet, fileName, row, counter, new BigDecimal(0.0));
        sheet.setColumnWidth(0, 1500);
        for (int i = 1; i < heards.size(); ++i) {
            sheet.setColumnWidth(i, 5000);
        }
        ExcelUtil.downloadExcel((HSSFWorkbook)workbook, (String)fileName, (HttpServletResponse)response);
    }

    @Override
    public void exportDatatoExcel2(QueryFilter<FundPlan> queryFilter, HttpServletResponse response) throws IOException {
        String date2Str;
        int i;
        List checkType = this.sdm.queryDictListItemsByCode("jdgl-yt");
        String fileName = "\u5408\u540c\u7ba1\u7406-\u672c\u6708\u8d44\u91d1\u8ba1\u5212-\u5bfc\u51fa\u7ed3\u679c";
        ArrayList<FundPlan> newList = new ArrayList<FundPlan>();
        ArrayList<FundPlan> oldList = new ArrayList<FundPlan>();
        Calendar cYear = Calendar.getInstance();
        int nowYear = cYear.get(1);
        Calendar cMonth = Calendar.getInstance();
        int nowMonth = cMonth.get(2) + 1;
        BizUtils.handleFilter(queryFilter, "bfp", false);
        queryFilter.addFilter("YEAR(PLAN_DATE_)", (Object)nowYear, QueryOP.EQUAL);
        queryFilter.addFilter("MONTH(PLAN_DATE_)", (Object)nowMonth, QueryOP.LESS_EQUAL);
        List data = ((FundPlanDao)this.baseMapper).queryAllByPage((IPage<FundPlan>)this.convert2IPage(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false))), (Wrapper<FundPlan>)this.convert2Wrapper(queryFilter, this.currentModelClass())).getRecords();
        ArrayList beforeList = new ArrayList();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM");
        if (null != data || data.size() != 0) {
            for (i = 0; i < data.size(); ++i) {
                date2Str = DateUtils.date2Str((Date)((FundPlan)((Object)data.get(i))).getContractDate(), (SimpleDateFormat)simpleDateFormat);
                Calendar c = Calendar.getInstance();
                try {
                    c.setTime(simpleDateFormat.parse(date2Str));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                if (c.get(2) + 1 == nowMonth) {
                    newList.add((FundPlan)((Object)data.get(i)));
                    continue;
                }
                beforeList.add(data.get(i));
            }
        }
        if (null != beforeList || beforeList.size() != 0) {
            for (i = 0; i < beforeList.size(); ++i) {
                date2Str = DateUtils.date2Str((Date)((FundPlan)((Object)beforeList.get(i))).getContractDate(), (SimpleDateFormat)simpleDateFormat);
                LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
                lambdaQueryWrapper.eq(ProgressManage::getPurpose, (Object)((FundPlan)((Object)beforeList.get(i))).getPurpose());
                lambdaQueryWrapper.like(ProgressManage::getRegisterPersonName, (Object)((FundPlan)((Object)beforeList.get(i))).getUnitNname());
                lambdaQueryWrapper.eq(ProgressManage::getProjectId, (Object)((FundPlan)((Object)beforeList.get(i))).getProjectId());
                lambdaQueryWrapper.like(ProgressManage::getRegisterDate, (Object)date2Str);
                List<ProgressManage> progressManages = this.pgm.fundplanGetProgressManage((LambdaQueryWrapper<ProgressManage>)lambdaQueryWrapper);
                if (progressManages != null && progressManages.size() != 0) continue;
                oldList.add((FundPlan)((Object)beforeList.get(i)));
            }
        }
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(fileName);
        HSSFRow titleRow = sheet.createRow(0);
        BizUtils.handelCell(workbook, fileName, titleRow.createCell(0), "\u8d44\u91d1\u8ba1\u5212\u8868", true);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 10));
        ArrayList<String> heards = new ArrayList<String>();
        heards.addAll(Arrays.asList("\u5e8f\u53f7", "\u9879\u76ee\u540d\u79f0", "\u5408\u540cID", "\u5408\u540c\u540d\u79f0", "\u8ba1\u5212\u65e5\u671f", "\u8d39\u7528\u540d\u79f0", "\u5355\u4f4d\u540d\u79f0", "\u91d1\u989d", "\u662f\u54262022\u5e74\u65b0\u5f00\u5de5\u9879\u76ee", "\u662f\u54262022\u5e74\u4e13\u9879\u503a\u7533\u62a5\u9879\u76ee", "\u5907\u6ce8"));
        ArrayList<String> litTittle = new ArrayList<String>();
        litTittle.addAll(Arrays.asList("\uff08\u4e00\uff09\u672c\u6708\u8d44\u91d1\u652f\u51fa\u8ba1\u5212", "\uff08\u4e8c\uff09\u4ee5\u524d\u6708\u5ea6\u5df2\u5217\u652f\u8ba1\u5212\u9700\u672c\u6708\u6536\u5165"));
        titleRow = sheet.createRow(1);
        for (int i2 = 0; i2 < heards.size(); ++i2) {
            BizUtils.handelCell(workbook, fileName, titleRow.createCell(i2), (String)heards.get(i2), new boolean[0]);
        }
        titleRow = sheet.createRow(2);
        BizUtils.handelCell(workbook, fileName, titleRow.createCell(0), (String)litTittle.get(0), new boolean[0]);
        sheet.addMergedRegion(new CellRangeAddress(2, 2, 0, 2));
        for (FundPlan fp : data) {
            fp.setPurpose(BizUtils.getDicValueByCode((List<DictModel>)checkType, fp.getPurpose()));
        }
        int counter = 1;
        int row = 3;
        BigDecimal totalMoney = new BigDecimal(0.0);
        List temp1 = this.exportToExcel(newList, workbook, sheet, fileName, row, counter, totalMoney);
        row = (Integer)temp1.get(0);
        totalMoney = (BigDecimal)temp1.get(1);
        titleRow = sheet.createRow(row);
        BizUtils.handelCell(workbook, fileName, titleRow.createCell(0), (String)litTittle.get(1), new boolean[0]);
        sheet.addMergedRegion(new CellRangeAddress(row, row, 0, 2));
        List temp2 = this.exportToExcel(oldList, workbook, sheet, fileName, ++row, counter, totalMoney);
        row = (Integer)temp2.get(0);
        totalMoney = (BigDecimal)temp2.get(1);
        HSSFRow rows = sheet.createRow(row);
        BizUtils.handelCell(workbook, fileName, rows.createCell(7), String.valueOf(totalMoney), new boolean[0]);
        sheet.setColumnWidth(0, 1500);
        for (int i3 = 1; i3 < heards.size(); ++i3) {
            sheet.setColumnWidth(i3, 5000);
        }
        ExcelUtil.downloadExcel((HSSFWorkbook)workbook, (String)fileName, (HttpServletResponse)response);
    }

    public List exportToExcel(List<FundPlan> list, HSSFWorkbook workbook, HSSFSheet sheet, String fileName, int row, int counter, BigDecimal totalMoney) {
        HSSFCellStyle cellStyle = workbook.createCellStyle();
        HSSFDataFormat dataFormat = workbook.createDataFormat();
        cellStyle.setDataFormat(dataFormat.getFormat("yyyy-MM"));
        if (null != list || list.size() != 0) {
            for (int i = 0; i < list.size(); ++i) {
                HSSFRow listRow = sheet.createRow(row);
                BizUtils.handelCell(workbook, fileName, listRow.createCell(0), String.valueOf(counter), new boolean[0]);
                BizUtils.handelCell(workbook, fileName, listRow.createCell(1), list.get(i).getProjectInfo().getProjectName(), new boolean[0]);
                BizUtils.handelCell(workbook, fileName, listRow.createCell(2), list.get(i).getContractId(), new boolean[0]);
                BizUtils.handelCell(workbook, fileName, listRow.createCell(3), list.get(i).getContractName(), new boolean[0]);
                HSSFCell cell4 = listRow.createCell(4);
                BizUtils.handelCell(workbook, fileName, cell4, DateUtils.date2Str((Date)list.get(i).getContractDate(), (SimpleDateFormat)new SimpleDateFormat("yyyy-MM")), new boolean[0]);
                cell4.setCellStyle(cellStyle);
                BizUtils.handelCell(workbook, fileName, listRow.createCell(5), list.get(i).getPurpose(), new boolean[0]);
                BizUtils.handelCell(workbook, fileName, listRow.createCell(6), list.get(i).getUnitNname(), new boolean[0]);
                BizUtils.handelCell(workbook, fileName, listRow.createCell(7), String.valueOf(list.get(i).getContractAmount()), new boolean[0]);
                BizUtils.handelCell(workbook, fileName, listRow.createCell(8), list.get(i).getHasNew(), new boolean[0]);
                BizUtils.handelCell(workbook, fileName, listRow.createCell(9), list.get(i).getHasSpecial(), new boolean[0]);
                BizUtils.handelCell(workbook, fileName, listRow.createCell(10), list.get(i).getRemarks(), new boolean[0]);
                if (list.get(i).getContractAmount() != null) {
                    totalMoney = totalMoney.add(list.get(i).getContractAmount());
                }
                ++row;
                ++counter;
            }
        }
        ArrayList<Number> result = new ArrayList<Number>();
        result.add(row);
        result.add(totalMoney);
        return result;
    }
}

