/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.wps.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.exception.BaseException;
import com.artfess.base.model.CommonResult;
import com.artfess.cqxy.universal.manager.AccessoryManager;
import com.artfess.cqxy.universal.model.Accessory;
import com.artfess.cqxy.wps.enums.FileTypeEnum;
import com.artfess.cqxy.wps.model.Url;
import com.artfess.cqxy.wps.model.WpsApp;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"WPS\u7b7e\u540d\u4fe1\u606f\u63a5\u53e3"}, description="\u53c2\u6570\u4f20\u9012\u6700\u597d\u4e0d\u8981\u51fa\u73b0\u4e2d\u6587\u7b49\u7279\u6b8a\u5b57\u7b26\uff0c\u5bb9\u6613\u5bfc\u81f4\u7b7e\u540d\u4e0d\u8fc7\u7b49\u95ee\u9898")
@ApiGroup(group={"group_biz"})
@RequestMapping(value={"/wps/oauth"})
public class SignatureController {
    private static final Logger log = LoggerFactory.getLogger(SignatureController.class);
    @Autowired
    @ApiModelProperty(value="\u9644\u4ef6\u4fe1\u606f\u670d\u52a1\u5bf9\u8c61\uff0c\u83b7\u53d6\u9700\u8981\u7684\u6587\u4ef6\u4fe1\u606f")
    private AccessoryManager accessoryManager;

    @GetMapping(value={"/olinePreview"})
    @ApiOperation(value="\u83b7\u53d6\u5728\u7ebf\u9884\u89c8PDF\u5730\u5740")
    public CommonResult<String> getAppToken(HttpServletResponse response, @RequestParam(value="_w_fileid") String fileId) throws Exception {
        if (fileId == null || fileId.isEmpty()) {
            throw new BaseException("\u6587\u4ef6ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Accessory accessory = (Accessory)((Object)this.accessoryManager.getById((Serializable)((Object)fileId)));
        if (null == accessory || StringUtils.isBlank((CharSequence)accessory.getUrl())) {
            throw new BaseException("\u62b1\u6b49\uff0c\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u88ab\u5220\u9664\uff01\uff01");
        }
        String suffix = accessory.getSuffix();
        String[] arr = new String[]{"doc", "docx", "xls", "xlsx", "ppt", "pptx", "pdf"};
        List<String> list = Arrays.asList(arr);
        String url = accessory.getUrl();
        String[] urlArr = url.split("/");
        String fileName = accessory.getName();
        if (list.contains(suffix)) {
            String filePath = this.accessoryManager.fileToPdf(accessory);
            if (StringUtils.isBlank((CharSequence)filePath)) {
                filePath = this.accessoryManager.minIoDownFile(accessory, urlArr[4]);
                filePath = filePath + this.encode(accessory.getName());
            } else {
                int i = fileName.lastIndexOf(".");
                filePath = i > -1 && i < fileName.length() - 1 ? filePath + this.encode(fileName.substring(0, i)) + ".pdf" : filePath + this.encode(fileName) + ".pdf";
            }
            return new CommonResult(true, "\u6587\u4ef6\u5730\u5740\u67e5\u8be2\u6210\u529f", (Object)filePath.replace("download", "/static/pdf"));
        }
        return new CommonResult(false, "\u5f53\u524d\u6587\u4ef6\u683c\u5f0f\u4e0d\u652f\u6301\u5728\u7ebf\u9884\u89c8", (Object)"");
    }

    private String encode(String s) {
        String s1 = s.replace("%", "%25").replace(" ", "%20").replace("\"", "%22").replace("#", "%23").replace("&", "%26").replace("(", "%28").replace(")", "%29").replace("+", "%2B").replace(",", "%2C").replace("/", "%2F").replace(":", "%3A").replace(";", "%3B").replace("<", "%3C").replace("=", "%3D").replace(">", "%3E").replace("?", "%3F").replace("@", "%40").replace("\\", "%5C").replace("|", "%7C");
        return s1;
    }

    @PostMapping(value={"/url"})
    @ApiOperation(value="\u83b7\u53d6AppToken")
    public CommonResult getAppToken(HttpServletRequest request, @RequestParam(value="_w_fileid") String fileId) {
        if (fileId == null || fileId.isEmpty()) {
            return null;
        }
        Accessory one = (Accessory)((Object)this.accessoryManager.getOne((Wrapper)new QueryWrapper().eq((Object)"ID_", (Object)fileId)));
        if (one.getId() != null) {
            fileId = one.getId();
        }
        String type = FileTypeEnum.getTypeBySuffix(one.getSuffix());
        String url = WpsApp.domain + "/office/" + type + "/" + fileId + "?";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("_w_appid", WpsApp.appid);
        paramMap.put("_w_fileid", fileId);
        paramMap.put("_w_tokentype", "1");
        String signature = this.getSignature(paramMap, WpsApp.appSecret);
        url = url + this.getUrlParam(paramMap) + "&_w_signature=" + signature;
        Url urlModel = new Url(url, request.getHeader("Authorization"));
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)urlModel);
    }

    private String getUrlParam(Map<String, String> params) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (builder.length() > 0) {
                builder.append('&');
            }
            builder.append(URLEncoder.encode(entry.getKey(), "utf-8")).append('=').append(URLEncoder.encode(entry.getValue(), "utf-8"));
        }
        return builder.toString();
    }

    private String getSignature(Map<String, String> params, String appSecret) {
        ArrayList<String> keys = new ArrayList<String>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            keys.add(entry.getKey());
        }
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        StringBuilder contents = new StringBuilder("");
        for (String key : keys) {
            if (key == "_w_signature") continue;
            contents.append(key + "=").append(params.get(key));
        }
        contents.append("_w_secretkey=").append(appSecret);
        byte[] byArray = HmacUtils.hmacSha1((byte[])appSecret.getBytes(), (byte[])contents.toString().getBytes());
        String sign = Base64.encodeBase64String((byte[])byArray);
        try {
            sign = URLEncoder.encode(sign, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        System.out.println(sign);
        return sign;
    }
}

