/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.bidManagement.manager.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.bidManagement.dao.BiddingPriceExamineDao;
import com.artfess.cqxy.bidManagement.manager.BiddingPriceExamineManager;
import com.artfess.cqxy.bidManagement.manager.BiddingPriceLimitManager;
import com.artfess.cqxy.bidManagement.model.BiddingPriceExamine;
import com.artfess.cqxy.projectManagement.enums.ProjectStatusEnum;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.search.enums.FunctionEnum;
import com.artfess.cqxy.search.manager.GlobalRetrievalManager;
import com.artfess.cqxy.search.model.GlobalRetrieval;
import com.artfess.cqxy.universal.manager.AccessoryManager;
import com.artfess.cqxy.universal.model.Accessory;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class BiddingPriceExamineManagerImpl
extends BaseManagerImpl<BiddingPriceExamineDao, BiddingPriceExamine>
implements BiddingPriceExamineManager {
    @Autowired
    private AccessoryManager accessoryManager;
    @Autowired
    private SysDictionaryManager sdm;
    @Autowired
    private BaseContext baseContext;
    @Autowired
    private GlobalRetrievalManager grm;
    @Autowired
    private ProjectManagementManager pmm;
    @Autowired
    private BiddingPriceLimitManager bplManager;

    public boolean saveOrUpdate(BiddingPriceExamine entity) {
        boolean save = StringUtils.isEmpty((CharSequence)entity.getId());
        boolean savedMain = super.saveOrUpdate((Object)entity);
        ArrayList<Accessory> flag = entity.getAccessoryInfo();
        ArrayList<Accessory> accessoryList = null == flag ? new ArrayList<Accessory>() : flag;
        for (Accessory ele : accessoryList) {
            ele.setSourceId(entity.getId());
            ele.setProjectId(entity.getProjectId());
            ele.setDirectory(ProjectStatusEnum.eight.getCode());
            ele.setGroup("BiddingPriceExamine");
            ele.setNode(ProjectStatusEnum.eight.getCode());
            ele.setCreateBy(this.baseContext.getCurrentUserId());
            ele.setCreateName(this.baseContext.getCurrentUserName());
            ele.setCreateTime(LocalDateTime.now());
        }
        this.accessoryManager.removeBySourceId(entity.getId());
        boolean saveAcc = accessoryList.size() == 0 || this.accessoryManager.saveAccess(accessoryList);
        this.pmm.updateStatusById(entity.getProjectId(), Integer.valueOf(ProjectStatusEnum.eight.getCode()));
        GlobalRetrieval globalRetrieval = this.grm.getByBizId(entity.getId());
        this.handleRetrieval(save || BeanUtils.isEmpty((Object)((Object)globalRetrieval)) ? new GlobalRetrieval() : globalRetrieval, entity);
        return savedMain && saveAcc;
    }

    private void handleRetrieval(GlobalRetrieval globalRetrieval, BiddingPriceExamine entity) {
        ProjectManagement projectManagement = (ProjectManagement)((Object)this.pmm.getById((Serializable)((Object)entity.getProjectId())));
        globalRetrieval.setProjectId(entity.getProjectId());
        globalRetrieval.setProjectName(projectManagement.getProjectName());
        globalRetrieval.setPersonCharge(projectManagement.getProjectManager());
        globalRetrieval.setArchivesType(1);
        globalRetrieval.setBizDataId(entity.getId());
        globalRetrieval.setFunctionCode(FunctionEnum.thirtyOne.getCode());
        globalRetrieval.setFunctionName(FunctionEnum.thirtyOne.getName());
        globalRetrieval.setBizTableName(FunctionEnum.thirtyOne.getTableName());
        globalRetrieval.setDetailsRoteUrl(FunctionEnum.thirtyOne.getTableRoteUrl());
        globalRetrieval.setTableRoteUrl(FunctionEnum.thirtyOne.getTableRoteUrl());
        globalRetrieval.setTableApiUrl(FunctionEnum.thirtyOne.getTableApiUrl());
        globalRetrieval.setDetailsApiUrl(FunctionEnum.thirtyOne.getDetailsApiUrl());
        globalRetrieval.setFunctionPath(FunctionEnum.thirtyOne.getFunctionPath());
        globalRetrieval.setDocumentNumber(String.valueOf(entity.getDocNumber()));
        globalRetrieval.setName(String.valueOf(entity.getName()));
        globalRetrieval.setSearchTitle(entity.getName() + "_" + entity.getTenderee() + "_" + entity.getDocNumber() + "_" + entity.getOwnerUnit() + "_" + entity.getProjectOverview() + entity.getTenderee() + "_" + entity.getHandler() + "_" + entity.getEstablishmentRemarks());
        this.grm.saveOrUpdate((Object)globalRetrieval);
    }

    @Override
    public boolean deleteByIds(List<String> ids) {
        for (String ele : ids) {
            this.grm.remove(1, ele);
        }
        return this.removeByIds(ids);
    }

    @Override
    public BiddingPriceExamine getById(String id) {
        BiddingPriceExamine result = ((BiddingPriceExamineDao)this.baseMapper).getById(id);
        result.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(id));
        return result;
    }

    @Override
    public PageList<BiddingPriceExamine> queryAllByPage(QueryFilter<BiddingPriceExamine> queryFilter) {
        queryFilter.addFilter("bbpe.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        queryFilter.addFilter("pm.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IPage<BiddingPriceExamine> result = ((BiddingPriceExamineDao)this.baseMapper).queryAllByPage((IPage<BiddingPriceExamine>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BiddingPriceExamine>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        for (BiddingPriceExamine ele : records) {
            ele.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(ele.getId()));
        }
        return new PageList(result);
    }

    @Override
    public void importExcelData(MultipartFile file, String projectId, String priceLimitId) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)priceLimitId, (String)"\u6e05\u5355\u4fe1\u606fID\u4e0d\u80fd\u4e3a\u7a7a");
        try (InputStream inputStream = file.getInputStream();){
            List data = ExcelImportUtil.importExcel((InputStream)inputStream, BiddingPriceExamine.class, (ImportParams)new ImportParams());
            for (BiddingPriceExamine ele : data) {
                ele.setProjectId(projectId);
                ele.setPriceLimitId(priceLimitId);
                try {
                    ele.setOwnerUnit(String.valueOf(ele.getDocNumber().divide(ele.getPriceCeiling(), 4, 6).multiply(BigDecimal.valueOf(100L))));
                }
                catch (Exception e) {
                    ele.setOwnerUnit("0.00");
                }
                this.save((Object)ele);
                this.handleRetrieval(new GlobalRetrieval(), ele);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exportDatatoExcel(QueryFilter<BiddingPriceExamine> queryFilter, HttpServletResponse response) throws IOException {
        String fileName = "\u62db\u6295\u6807-\u6e05\u5355\u9650\u4ef7-\u5ba1\u6838-\u5bfc\u51fa\u7ed3\u679c";
        BizUtils.handleFilter(queryFilter, "bbpl", "pm");
        queryFilter.addFilter("bbpe.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        List data = ((BiddingPriceExamineDao)this.baseMapper).queryAllByPage((IPage<BiddingPriceExamine>)this.convert2IPage(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false))), (Wrapper<BiddingPriceExamine>)this.convert2Wrapper(queryFilter, this.currentModelClass())).getRecords();
        if (null == data || data.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u8981\u5bfc\u51fa\u7684\u7684\u6570\u636e\uff01");
        }
        ExportParams exportParams = BizUtils.getExportParams(fileName);
        fileName = fileName + ".xlsx";
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, BiddingPriceExamine.class, (Collection)data);
        ExcelUtil.downloadExcel((Workbook)workbook, (String)fileName, (HttpServletResponse)response);
    }

    @Override
    public void updateProjectIdByProiectId(String oldProjectIds, String newProjectId) {
        UpdateWrapper wrapper = (UpdateWrapper)new UpdateWrapper().set(StringUtils.isNotBlank((CharSequence)newProjectId), "PROJECT_ID_", (Object)newProjectId).in((Object)"PROJECT_ID_", Arrays.asList(oldProjectIds.split(",")));
        this.update((Wrapper)wrapper);
    }
}

