package com.artfess.dataAccess.aop;

import com.artfess.base.context.BaseContext;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.AuthenticationUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.HttpUtil;
import com.artfess.dataAccess.manager.DataAccessDefinedManager;
import com.artfess.uc.model.User;
import com.artfess.uc.util.ContextUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Package com.scaffold.log.aspect
 * date 2021/3/30 19:41
 * author wh
 * Description:数据权限切面处理类
 */
@Aspect
@Component
public class DataAccessAspect {

    //本地异常日志记录对象
    private static final Logger logger = LogManager.getLogger("PermissionData");
    public static final String CREATE_BY_ = "CREATE_BY_";
    public static final String CREATE_ORG_ID_ = "CREATE_ORG_ID_";
    @Autowired
    @Lazy
    DataAccessDefinedManager dataAccessDefinedManager;

    @Resource
    BaseContext baseContext;

    /**
     * 正常返回通知，拦截用户操作，连接点正常执行完成后执行， 如果连接点抛出异常，则不会执行
     *
     * @param joinPoint 切入点
     */
    @Around("execution(* *..*Controller.*(..)) && @annotation(com.artfess.base.annotation.DataAccess)")
    public Object checkPermission(ProceedingJoinPoint joinPoint) throws Throwable {
        try {
            Object[] params = joinPoint.getArgs();

            // 当前切中的方法
            HttpServletRequest request = HttpUtil.getRequest();
            if (request == null) {
                return joinPoint.proceed();
            }
            String reqUri = request.getRequestURI();
            logger.debug(" 请求地址   " + reqUri);
            request.setAttribute("url",reqUri);
            //根据请求url查询登录人员的数据权限
            List<Map<String, Object>> maps=dataAccessDefinedManager.getDataAccessDefinedList(reqUri);
            // 处理select sql 的情况
            for (Object object : params) {
                if( object instanceof QueryFilter){
                    QueryFilter filter = (QueryFilter) object;
                    for (Map<String, Object> item : maps) {
                        //1：本人  2：本人及直属下级 3：本组织数据 4：本组织及以下组织数据 5 指定组织 6 指定用户 7：所有
                        String type = item.get("ACCESS_RANGE_TYPE_").toString();
                        Object rangeId = item.get("ACCESS_RANGE_ID");
                        String accessRangeId ="";
                        if (rangeId!=null){
                         accessRangeId = rangeId.toString();
                        }
                        if ("1".indexOf(type) != -1) {
                            String userId = AuthenticationUtil.getCurrentUserId();
                            filter.addFilter(CREATE_BY_, userId, QueryOP.EQUAL, FieldRelation.OR,"dataPermission");
                        }else if ("2".indexOf(type) != -1) {
                             List<User> list = ContextUtil.getCurrentUserUnder();
                             accessRangeId = AuthenticationUtil.getCurrentUserId();
                             if(list!=null && list.size()>0){
                                 for(User user : list){
                                     if(user!=null){
                                         accessRangeId = accessRangeId+","+user.getId();
                                     }
                                 }
                             }
                            filter.addFilter(CREATE_BY_, String.join("','",accessRangeId), QueryOP.IN,FieldRelation.OR,"dataPermission");
                        }else if ("3".indexOf(type) != -1) {
                            if (StringUtils.isNotEmpty(accessRangeId)) {
                                filter.addFilter(CREATE_ORG_ID_, String.join("','", accessRangeId), QueryOP.IN, FieldRelation.OR, "dataPermission");
                            }
                        }else if ("4".indexOf(type) != -1) {
//                            String subOrgIds = AuthenticationUtil.getCurrentUserId();
                            String subOrgIds =  baseContext.getCurrentOrgId();
                            filter.addFilter(CREATE_ORG_ID_, String.join("','",subOrgIds), QueryOP.IN,FieldRelation.OR,"dataPermission");
                        }else if ("5".indexOf(type) != -1) {
                            if (StringUtils.isNotEmpty(accessRangeId)) {
                                filter.addFilter(CREATE_ORG_ID_, String.join("','", accessRangeId), QueryOP.IN, FieldRelation.OR, "dataPermission");
                            }
                        }else if ("6".indexOf(type) != -1) {
                            if (StringUtils.isNotEmpty(accessRangeId)) {
                                filter.addFilter(CREATE_BY_, String.join("','", accessRangeId), QueryOP.IN, FieldRelation.OR, "dataPermission");
                            }
                        }
                    }
                }
            }



            Object object = joinPoint.proceed();
            return object;
        } catch (Exception e) {
            logger.info("环绕切面方法报错，不影响实际业务" + e.getMessage());
            Object object = joinPoint.proceed();
            return object;
        } finally {

        }
    }




}