package com.artfess.report.bigScreen.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.StringUtil;
import com.artfess.report.bigScreen.manager.BladeVisualDbManager;
import com.artfess.report.bigScreen.model.BladeVisualCategory;
import com.artfess.report.bigScreen.model.BladeVisualDb;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * 可视化数据源配置表 前端控制器
 *
 * @author 超级管理员
 * @company 阿特菲斯
 * @since 2021-07-12
 */
@RestController
@RequestMapping("/bigScreen/bladeVisualDb/v1")
@Api(tags = "可视化数据源配置")
@ApiGroup(group = {ApiGroupConsts.GROUP_APPLICATION})
public class BladeVisualDbController extends BaseController<BladeVisualDbManager, BladeVisualDb> {
    @Resource
    BladeVisualDbManager bladeVisualDbManager;


    /**
     * 可视化数据源配置列表(分页条件查询)数据
     *
     * @param queryFilter
     * @return
     * @throws Exception PageJson
     * @throws
     */
    @PostMapping("/list")
    @ApiOperation(value = "可视化数据源配置列表", httpMethod = "POST", notes = "获取可视化数据源配置列表")
    public PageList<BladeVisualDb> list(@ApiParam(name = "queryFilter", value = "查询对象") @RequestBody QueryFilter<BladeVisualDb> queryFilter) throws Exception {
        return bladeVisualDbManager.query(queryFilter);
    }
    @RequestMapping(value = "updateBatch", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "逻辑删除", httpMethod = "POST", notes = "逻辑删除")
    public CommonResult<String> updateBatchBladeVisualDb(@ApiParam(name = "id", value = "可视化分类ID", required = true) @RequestParam(value = "id", required = true) String id) throws Exception {

        if (StringUtils.isNotBlank(id))
            bladeVisualDbManager.updateBatchBladeVisualDb(id);
        return new CommonResult<>(true, "删除成功");
    }
    /**
     * 可视化数据源配置明细页面
     *
     * @param id
     * @return
     * @throws Exception ModelAndView
     */
    @GetMapping(value = "/get/{id}")
    @ApiOperation(value = "可视化数据源配置详情", httpMethod = "GET", notes = "可视化数据源配置详情")
    public BladeVisualDb get(@ApiParam(name = "id", value = "业务对象主键", required = true) @PathVariable String id) throws Exception {
        return bladeVisualDbManager.get(id);
    }

    /**
     * 新增可视化数据源配置
     *
     * @param
     * @return
     * @throws Exception
     * @throws
     */
    @PostMapping(value = "/save")
    @ApiOperation(value = "新增,更新可视化数据源配置", httpMethod = "POST", notes = "新增,更新可视化数据源配置")
    public CommonResult<String> save(@ApiParam(name = "BladeVisualDb", value = "可视化数据源配置对象", required = true) @RequestBody BladeVisualDb BladeVisualDb) throws Exception {
        String msg = "添加可视化数据源配置成功";
        if (StringUtil.isEmpty(BladeVisualDb.getId())) {
            bladeVisualDbManager.create(BladeVisualDb);
        } else {
            bladeVisualDbManager.update(BladeVisualDb);
            msg = "更新可视化数据源配置成功";
        }
        return new CommonResult<String>(msg);
    }

    /**
     * 删除可视化数据源配置记录
     *
     * @param id
     * @return
     * @throws Exception
     * @throws
     */
    @DeleteMapping(value = "/remove/{id}")
    @ApiOperation(value = "删除可视化数据源配置", httpMethod = "DELETE", notes = "删除可视化数据源配置")
    public CommonResult<String> remove(@ApiParam(name = "id", value = "业务主键", required = true) @PathVariable String id) throws Exception {
        bladeVisualDbManager.remove(id);
        return new CommonResult<String>(true, "删除成功");
    }

    @RequestMapping(value = "queryBladeVisualDb", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "下拉数据源", httpMethod = "POST", notes = "下拉数据源")
    public List<BladeVisualDb> queryBladeVisualDb(@ApiParam(name = "route", value = "通用查询对象") @RequestBody BladeVisualDb bladeVisualDb) throws Exception {
        return bladeVisualDbManager.queryBladeVisualDb(bladeVisualDb);
    }

}
