package com.artfess.cqxy.universal.model;


import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 通用附件表(BizAccessory)表实体类
 * @author 黎沐华
 * @since 2022-02-16 17:14:40
 */
@TableName("BIZ_ACCESSORY")
@ApiModel(value="Accessory", description="通用附件表")
public class Accessory extends BizModel<Accessory> {

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID（关联项目管理表ID）")
    private String projectId;

    @TableField("PROJECT_NAME_")
    @ApiModelProperty(value = "项目名称（关联项目管理表NAME）")
    private String projectName;

    @TableField("TYPE_")
    @ApiModelProperty(value = "附件类型（使用字典，1：图片，2：文档，3：压缩文件，4：视频，5：其它）")
    private Integer type;

    @TableField("NAME_")
    @ApiModelProperty(value = "附件名")
    private String name;

    @TableField("SOURCE_ID_")
    @ApiModelProperty(value = "对应资源Id")
    private String sourceId;

    @TableField("URL_")
    @ApiModelProperty(value = "访问下载路径")
    private String url;

    @TableField("SUFFIX_")
    @ApiModelProperty(value = "后缀")
    private String suffix;

    @TableField("GROUP_")
    @ApiModelProperty(value = "分组标识，组名等于表对象名，（当一个表单有多个地方存在附件时可以使用此字段进行标识）")
    private String group;

    @TableField("FILE_SIZE_")
    @ApiModelProperty(value = "文件大小，单位MB")
    private String fileSize;

    @TableField("FILE_SIZE_B_")
    @ApiModelProperty(value = "文件大小，单位B")
    private Long fileSizeB;

    @TableField("REMARKS_")
    @ApiModelProperty(value = "备注")
    private String remarks;

    @TableField("DIRECTORY_")
    @ApiModelProperty(value = "对应目录，需要与目录编码、项目状态保持一致（使用项目立项-项目状态字典1：决策阶段，2：立项阶段：3：可研规划阶段，4：初步设计阶段，5：概算阶段，6：施工图设计阶段:，7：环评阶段，8：水保阶段，9：招投标阶段，10：施工许可审批阶段，11：施工阶段，12：竣工验收阶段，13：结算阶段，14：决算阶段，15：已完成）")
    private String directory;

    @TableField("NODE_")
    @ApiModelProperty(value = "所属文件节点，与对应目录字段一样，使用项目立项-项目状态字典")
    private String node;

    /**
     * 获取主键值
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "Accessory{" +
                "id='" + id + '\'' +
                ", projectId='" + projectId + '\'' +
                ", projectName='" + projectName + '\'' +
                ", type=" + type +
                ", name='" + name + '\'' +
                ", sourceId='" + sourceId + '\'' +
                ", url='" + url + '\'' +
                ", suffix='" + suffix + '\'' +
                ", group='" + group + '\'' +
                ", fileSize='" + fileSize + '\'' +
                ", fileSizeB=" + fileSizeB +
                ", remarks='" + remarks + '\'' +
                ", directory='" + directory + '\'' +
                ", node='" + node + '\'' +
                '}';
    }

    public String getFileSize() {
        return fileSize;
    }

    public void setFileSize(String fileSize) {
        this.fileSize = fileSize;
    }

    public String getId() {
        return id;
    }

    public Long getFileSizeB() {
        return fileSizeB;
    }

    public void setFileSizeB(Long fileSizeB) {
        this.fileSizeB = fileSizeB;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getSuffix() {
        return suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getGroup() {
        return group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getDirectory() {
        return directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getNode() {
        return node;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
}

