package com.artfess.cqxy.projectManagement.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.projectManagement.vo.ProjectPersonnelVo;
import com.artfess.cqxy.projectManagement.model.ProjectPersonnel;

import java.util.List;

/**
 * 项目人员中间表(BizProjectPersonnel)表服务接口
 *
 * @author 黎沐华
 * @since 2022-02-12 14:41:17
 */
public interface ProjectPersonnelManager extends BaseManager<ProjectPersonnel> {

    /**
     * 分页查询所有数据
     * @param queryFilter 通用查询器
     * @return 数据集合
     */
    PageList<ProjectPersonnelVo> queryAllByPage(QueryFilter<ProjectPersonnel> queryFilter);

    /**
     * 所有用户，用于添加项目时添加所有用户到中间表以及添加时的用户选择
     * @param projectId 项目ID 添加选择人员时，传入对应项目ID以列出不在该项目中的人员以供添加；
     *                  新建项目将链接所有用户时 传入空串即可
     * @return 项目人员Vo
     */
    List<ProjectPersonnelVo> getAllUsers(String projectId);

    /**
     * 关联所有用户到项目人员中间表
     * 注意：这里原本使用布尔返回值，与项目添加成功状态强关联
     *      使用基础类型将会在切面中抛出类型不匹配错误，需要使用包装类
     *      {Null return value from advice does not match primitive
     *      return type for: 方法签名}
     *      引起错误的原因是org.springframework.aop.framework.CglibAopProxy中
     *      对于returnType的检查，如果 (空 && 不为void && 是基础类型) 时就会抛出该异常     *
     *
     *      这里的异常由SysLogAspect抛出，该切面切中了所有控制器
     *      如果采用原先的布尔值方式，那么该方法不要在控制层使用也能避免该异常
     * @param projectId 项目ID
     */
    void linkUsers(String projectId);


    /**
     * 将项目管理者添加到项目管理中
     * @param projectId
     * @param projectManagerId
     */
    void linkUsersByProjectManager(String projectId, String projectManagerId);


    /**
     * 通过ID获取VO对象
     * @param id ID
     * @return VO对象
     */
    ProjectPersonnelVo getVoById(String id);

    /**
     * 允许在一个 ProjectPersonnel 中的personnelId 中传入多个id，以英文逗号隔开，该方法将对其处理并做批量添加
     * @param perObject 数据对象
     * @return 添加成功与否
     */
    boolean batchSaveData(ProjectPersonnel perObject);


    /**
     *
     * 根据项目ID查询项目管理人员
     * @return 返回项目所有人员list集合
     */
    List<String> getProjectPersonnelByProjectId(String projectId);

    /**
     *
     * 根据人员ID查询项目
     * @return 返回项目所有项目list集合
     */
    List<String> getProjectByPersonnelId(String personnelId);


}

