package com.artfess.cqxy.processManagermant.dao;

import java.util.List;

import com.artfess.cqxy.processManagermant.model.SecurityManage;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;
import com.artfess.cqxy.processManagermant.model.SecurityManage;

/**
 * 过程管理 - 安全管理(BizSecurityManage)表数据库访问层
 *
 * @author 黎沐华
 * @since 2022-03-04 15:40:47
 */
public interface SecurityManageDao extends BaseMapper<SecurityManage> {

    /**
     * 通过ID获取数据，关联项目信息，不能使用原生查询
     * @param id ID
     * @return 一条数据
     */
    SecurityManage getById(@Param("id") String id);

    /**
     * 分页查询所有数据
     * @param convert2IPage 分页对象
     * @param convert2Wrapper 查询参数
     * @return 数据集合
     */
    IPage<SecurityManage> queryAllByPage(IPage<SecurityManage> convert2IPage, @Param(Constants.WRAPPER) Wrapper<SecurityManage> convert2Wrapper);

}

