package com.artfess.cqxy.ledger.vo;

import com.artfess.base.annotation.BigDecimalFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author Limuhua
 * @date 2022/3/30 16:48
 */
@Data
public class InvestmentMonthCountVo {

    @ApiModelProperty(value = "月份")
    private Integer month;

    @BigDecimalFormat
    @ApiModelProperty(value = "本月投资")
    private BigDecimal currentInvestment;

    @ApiModelProperty(value = "本月进度")
    private String progress;

    @BigDecimalFormat
    @ApiModelProperty(value = "累计总投资")
    private BigDecimal totalInvestment;

    @Override
    public String toString() {
        return "InvestmentMonthCountVo{" +
                "month=" + month +
                ", currentInvestment='" + currentInvestment + '\'' +
                ", progress='" + progress + '\'' +
                ", totalInvestment='" + totalInvestment + '\'' +
                '}';
    }

}
