package com.artfess.cqxy.ledger.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author Limuhua
 * @date 2022/3/30 15:22
 */
@Data
public class InvestmentLedgerVo {

    @ApiModelProperty(value = "项目ID")
    private String id;

    // 项目表
    @ApiModelProperty(value = "项目名")
    private String projectName;

    @ApiModelProperty(value = "项目负责人")
    private String projectManager;

    @ApiModelProperty(value = "形象进度/项目状态（字典）")
    private String projectStatus;

    @ApiModelProperty("项目类型")
    private Integer projectType;

    @ApiModelProperty("土地费用")
    // 项目管理中有个土地总价字段，如果不为空就取这个字段值，如果为空就根据项目查询项目管理-编制-设计概算-概算批复中【土地费用】的值
    private BigDecimal landPrice;

    // 工程月报表按月统计
    @ApiModelProperty(value = "工程月报表按月统计")
    private List<InvestmentMonthCountVo> monthCount;

    // 概算表 建安及总投资
    @ApiModelProperty(value = "总投资额（单位：万元）")
    private String totalEstimate;

    // 合同表 施工合同金额总和
    @ApiModelProperty(value = "建安费用")
    private String engineeringCost;

    // 工程支付表
    // 工程支付中用途不为工程款和安全文明施工费的费用总和
    @ApiModelProperty("二类费用")
    private BigDecimal twoTypePrice;

    @ApiModelProperty(value = "安全文明施工费")
    private String actualSettlementAmount;

    @ApiModelProperty(value = "当年年度总投资（单位：万元）")
    private String currentEstimate;

    @ApiModelProperty(value = "去年年度总投资（单位：万元）")
    private String beforeEstimate;

    @ApiModelProperty(value = "累计完成总投资（单位：万元）")
    private String completedEstimate;

    @ApiModelProperty("累计行政缴费总额")
    private BigDecimal adminPaymentAmount;
}
