package com.artfess.cqxy.ledger.controller;

import cn.hutool.json.JSONObject;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.ledger.manager.InvestmentLedgerManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Map;

/**
 * @author Limuhua
 * @date 2022/3/30 14:47
 */
@Slf4j
@RestController
@Api(tags = "台账-投资进度台账接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@RequestMapping("/biz/ledger/investment/v1")
public class InvestmentLedgerController {

    @Autowired
    private InvestmentLedgerManager manager;

    /**
     * 分页查询所有数据
     * @param queryFilter 通用查询器
     * @return 分页数据
     */
    @PostMapping("/page")
    @ApiOperation(value = "S-分页查询所有数据",notes = "使用项目查询器，XX年项目即开工时间为 YEAR(COMMENCEMENT_TIME_)", httpMethod = "POST")
    public CommonResult<Map<String, Object>>  page(
            @ApiParam(name = "queryFilter",value = "项目查询器")
            @RequestBody QueryFilter<ProjectManagement> queryFilter) {
        Map<String, Object> result = manager.queryByPage(queryFilter);
        return new CommonResult<>(true, "操作成功", result);
    }

    /**
     * 导出数据到Excel
     * @param queryFilter 通用查询器
     * @param response 响应对象
     * @return 通用结果
     * @throws IOException IO异常
     */
    @PostMapping("/exportDataToExcel")
    @ApiOperation(value = "S-导出数据到Excel",notes = "使用项目查询器，XX年项目即开工时间为 YEAR(COMMENCEMENT_TIME_)")
    public CommonResult exportDataToExcel (
            @ApiParam(name = "queryFilter",value = "通用查询器")@RequestBody QueryFilter<ProjectManagement> queryFilter,
            HttpServletResponse response) throws Exception {
        manager.exportDataToExcel(queryFilter,response);
        return new CommonResult<>("导出成功");
    }

    @PostMapping("/yearTotalInvest")
    @ApiOperation(value = "S-年度总投资",notes = "传入年份 year")
    public CommonResult yearTotalInvest (
            @ApiParam(name = "year",value = "统计年份")@RequestParam Integer year){
        JSONObject result = manager.yearTotalInvest(year);
        return new CommonResult<>(true, "操作成功", result);
    }

    @PostMapping("/totalInvestByYear")
    @ApiOperation(value = "S-年度总投资",notes = "传入年份 year")
    public CommonResult totalInvestByYear (
            @ApiParam(name = "year",value = "统计年份")@RequestParam Integer year){
        BigDecimal result = manager.totalInvestByYear(year);
        return new CommonResult<>(true, "操作成功", result);
    }

}
