package com.artfess.cqxy.feasiblePlan.model;


import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import com.artfess.base.entity.BizModel;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 规划许可-用地表(BizPlanningUseLand)表实体类
 * @author 黎沐华
 * @since 2022-02-15 10:39:59
 */
@Data
@TableName("biz_planning_use_land")
@ApiModel(value="可研规划-规划许可-用地对象-PlanningUseLand", description="规划许可-用地表")
public class PlanningUseLand extends BizModel<PlanningUseLand> {

    // 关联项目的信息放在开头，以便在导出时先导出项目中的配置，而不用进行额外的位置配置
    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的项目信息")
    private ProjectManagement projectInfo;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID（关联项目管理表ID）")
    private String projectId;

    @TableField("LAND_MONEY_")
    @ApiModelProperty(value = "土地费")
    private BigDecimal landMoney;

    @Excel(name = "批准机关")
    @TableField("ESTABLISHMENT_APPROVAL_UNIT_")
    @ApiModelProperty(value = "批准机关")
    private String establishmentApprovalUnit;

    @Excel(name = "批准日期",format = "yyyy-MM-dd")
    @TableField("ESTABLISHMENT_DATE_")
    @ApiModelProperty(value = "批准日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date establishmentDate;

    @Excel(name = "取得使用权方式")
    @TableField("LAND_RIGHT_ACQUISITION_MODE_")
    @ApiModelProperty(value = "取得土地使用权方式（使用字典，1：划拨，2：出让3：转让）")
    private String landRightAcquisitionMode;

    @Excel(name = "土地用途")
    @TableField("PARCEL_PURPOSE_")
    @ApiModelProperty(value = "土地用途")
    private String parcelPurpose;

    @Excel(name = "用地总面积(m²)")
    @TableField("PROPOSED_LAND_AREA_")
    @ApiModelProperty(value = "用地总面积(平方米)")
    private String proposedLandArea;

    @Excel(name = "备注")
    @TableField("ESTABLISHMENT_REMARKS_")
    @ApiModelProperty(value = "备注")
    private String establishmentRemarks;

//    @Excel(name = "名称")
    @TableField("NAME_")
    @ApiModelProperty(value = "名称")
    private String name;

//    @Excel(name = "编号")
    @TableField("CODE_")
    @ApiModelProperty(value = "编号")
    private String code;

//    @Excel(name = "批准文号")
    @TableField("DOCUMENT_NUMBER_")
    @ApiModelProperty(value = "批准文号")
    private String documentNumber;

//    @Excel(name = "建设项目名称")
    @TableField("CONSTRUCTION_PROJECT_NAME_")
    @ApiModelProperty(value = "建设项目名称")
    private String constructionProjectName;

    @Excel(name = "土地坐落(位置)")
    @TableField("PROPOSED_LOCATION_")
    @ApiModelProperty(value = "土地坐落(位置)")
    private String proposedLocation;

//    @Excel(name = "建筑容积率")
    @TableField("BUILDING_FLOOR_AREA_RATIO_")
    @ApiModelProperty(value = "建筑容积率")
    private String buildingFloorAreaRatio;

    @Excel(name = "开工时间")
    @TableField("COMMENCEMENT_TIME_")
    @ApiModelProperty(value = "开工时间（时间格式：年-月)")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date commencementTime;

    @Excel(name = "竣工时间")
    @TableField("COMPLETION_TIME_")
    @ApiModelProperty(value = "竣工时间（时间格式：年-月)")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date completionTime;

    @Excel(name = "有效期开始时间")
    @TableField("EFFECTIVE_START_TIME_")
    @ApiModelProperty(value = "有效期开始时间（时间格式：年-月)")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date effectiveStartTime;

    @Excel(name = "有效期结束时间")
    @TableField("EFFECTIVE_END_TIME_")
    @ApiModelProperty(value = "有效期结束时间（时间格式：年-月)")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date effectiveEndTime;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件信息")
    private List<Accessory> accessoryInfo;

    /**
     * 获取主键值
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "PlanningUseLand{" +
                "id='" + id + '\'' +
                ", projectId='" + projectId + '\'' +
                ", name='" + name + '\'' +
                ", code='" + code + '\'' +
                ", landRightAcquisitionMode=" + landRightAcquisitionMode +
                ", documentNumber='" + documentNumber + '\'' +
                ", establishmentApprovalUnit='" + establishmentApprovalUnit + '\'' +
                ", establishmentDate=" + establishmentDate +
                ", constructionProjectName='" + constructionProjectName + '\'' +
                ", parcelPurpose='" + parcelPurpose + '\'' +
                ", proposedLandArea='" + proposedLandArea + '\'' +
                ", proposedLocation='" + proposedLocation + '\'' +
                ", buildingFloorAreaRatio='" + buildingFloorAreaRatio + '\'' +
                ", commencementTime='" + commencementTime + '\'' +
                ", completionTime='" + completionTime + '\'' +
                ", effectiveStartTime='" + effectiveStartTime + '\'' +
                ", effectiveEndTime='" + effectiveEndTime + '\'' +
                ", establishmentRemarks='" + establishmentRemarks + '\'' +
                ", projectInfo=" + projectInfo +
                ", accessoryInfo=" + accessoryInfo +
                '}';
    }

}

