package com.artfess.cqxy.feasiblePlan.dao;

import com.artfess.cqxy.feasiblePlan.model.PlanningEngineering;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

/**
 * 规划许可-工程规划表(BizPlanningEngineering)表数据库访问层
 * @author 黎沐华
 * @since 2022-02-15 15:14:13
 */
public interface PlanningEngineeringDao extends BaseMapper<PlanningEngineering> {

    /**
     * 通过ID获取数据，关联项目信息，不能使用原生查询
     *
     * @param id ID
     * @return 一条数据
     */
    PlanningEngineering getById(@Param("id") String id);

    /**
     * 分页查询所有数据
     *
     * @param convert2IPage   分页对象
     * @param convert2Wrapper 查询参数
     * @return 数据集合
     */
    IPage<PlanningEngineering> queryAllByPage(IPage<PlanningEngineering> convert2IPage, @Param(Constants.WRAPPER) Wrapper<PlanningEngineering> convert2Wrapper);

}

