package com.artfess.cqxy.constructionPermit.dao;

import com.artfess.cqxy.constructionPermit.model.ConstructionPermit;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

/**
 * 五方责任主体对象(原施工许可表)(BizConstructionPermit)表数据库访问层
 * @author 黎沐华
 * @since 2022-02-23 10:24:54
 */
public interface ConstructionPermitDao extends BaseMapper<ConstructionPermit> {

    /**
     * 通过ID获取数据，关联项目信息，不能使用原生查询
     * @param id ID
     * @return 一条数据
     */
    ConstructionPermit getById(@Param("id") String id);

    /**
     * 分页查询所有数据
     * @param convert2IPage 分页对象
     * @param convert2Wrapper 查询参数
     * @return 数据集合
     */
    IPage<ConstructionPermit> queryAllByPage(IPage<ConstructionPermit> convert2IPage, @Param(Constants.WRAPPER) Wrapper<ConstructionPermit> convert2Wrapper);

}

