package com.artfess.cqxy.bidManagement.dao;

import java.util.List;

import com.artfess.cqxy.bidManagement.model.BidManagement;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;
import com.artfess.cqxy.bidManagement.model.BidManagement;

/**
 * 招投标管理 - 投标管理表(BidManagement)表数据库访问层
 *
 * @author 黎沐华
 * @since 2022-04-08 15:34:31
 */
public interface BidManagementDao extends BaseMapper<BidManagement> {

    /**
     * 通过ID获取数 据，关联项目信息，不能使用原生查询
     * @param id ID
     * @return 一条数据
     */
    BidManagement getById(@Param("id") String id);

    /**
     * 分页查询所有数据
     * @param convert2IPage 分页对象
     * @param convert2Wrapper 查询参数
     * @return 数据集合
     */
    IPage<BidManagement> queryAllByPage(IPage<BidManagement> convert2IPage, @Param(Constants.WRAPPER) Wrapper<BidManagement> convert2Wrapper);

}

