package com.artfess.cqxy.search.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 档案全局检索表(BizGlobalRetrieval)表实体类
 *
 * @author 黎沐华
 * @since 2022-03-22 15:50:18
 */
@TableName("BIZ_GLOBAL_RETRIEVAL")
@ApiModel(value="档案全局检索对象-GlobalRetrieval", description="档案全局检索表-进度管理-本次拨款明细表")
public class GlobalRetrieval extends BizModel<GlobalRetrieval> {

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID")
    private String projectId;

    @TableField("PROJECT_NAME_")
    @ApiModelProperty(value = "项目名称")
    private String projectName;

    @TableField("PERSON_CHARGE_")
    @ApiModelProperty(value = "负责人")
    private String personCharge;

    @TableField("FUNCTION_CODE_")
    @ApiModelProperty(value = "所属功能编码（只有有功能页面的就自行编码，最好做成枚举类，）")
    private String functionCode;

    @TableField("FUNCTION_NAME_")
    @ApiModelProperty(value = "所属功能名称（对应的功能名称）")
    private String functionName;

    @TableField("ARCHIVES_TYPE_")
    @ApiModelProperty(value = "档案类别（1：项目信息，2：项目文件）")
    private Integer archivesType;

    @TableField("BIZ_TABLE_NAME_")
    @ApiModelProperty(value = "业务数据_表名称")
    private String bizTableName;

    @TableField("BIZ_DATA_ID_")
    @ApiModelProperty(value = "业务数据表_业务数据ID【关联的业务主键】")
    private String bizDataId;

    @TableField("DETAILS_ROTE_URL_")
    @ApiModelProperty(value = "详情路由地址")
    private String detailsRoteUrl;

    @TableField("TABLE_ROTE_URL_")
    @ApiModelProperty(value = "列表路由地址，URL中最后一个/")
    private String tableRoteUrl;

    @TableField("TABLE_API_URL_")
    @ApiModelProperty(value = "列表后台接口地址")
    private String tableApiUrl;

    @TableField("DETAILS_API_URL_")
    @ApiModelProperty(value = "详情后台接口地址")
    private String detailsApiUrl;

    @TableField("FUNCTION_PATH_")
    @ApiModelProperty(value = "功能路径（根据功能存储路径，例如土地功能：可研规划>规划许可>土地）")
    private String functionPath;

    @TableField("NAME_")
    @ApiModelProperty(value = "文件名称，业务数据填的名称")
    private String name;

    @TableField("DOCUMENT_NUMBER_")
    @ApiModelProperty(value = "批复文号")
    private String documentNumber;

    @TableField("DOCUMENT_UNIT_")
    @ApiModelProperty(value = "批复单位")
    private String documentUnit;

    @TableField("CERTIFICATE_NUMBER_")
    @ApiModelProperty(value = "证书编号（EG： 规划-土地  编号")
    private String certificateNumber;

    @TableField("CERTIFICATE_UNIT_")
    @ApiModelProperty(value = "发证单位")
    private String certificateUnit;

    @TableField("FILE_TYPE_")
    @ApiModelProperty(value = "附件类型（使用字典，1：图片，2：文档，3：压缩文件，4：视频，5：其它）")
    private Integer fileType;

    @TableField("FILE_NAME_")
    @ApiModelProperty(value = "附件名称")
    private String fileName;

    @TableField("FILE_SOURCE_ID_")
    @ApiModelProperty(value = "附件对应资源Id")
    private String fileSourceId;

    @TableField("FILE_URL_")
    @ApiModelProperty(value = "附件访问下载路径")
    private String fileUrl;

    @TableField("FILE_SUFFIX_")
    @ApiModelProperty(value = "附件后缀")
    private String fileSuffix;

    @TableField("FILE_GROUP_")
    @ApiModelProperty(value = "附件分组标识，（当一个表单有多个地方存在附件时可以使用此字段进行标识）")
    private String fileGroup;

    @TableField("FILE_SIZE_")
    @ApiModelProperty(value = "文件大小,（单位：MB）")
    private String fileSize;

    @TableField("SEARCH_TITLE_")
    @ApiModelProperty(value = "文件检索字段（用于检索的字段，业务数据保存时保存）")
    private String searchTitle;

    /**
     * 获取主键值
     *
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "GlobalRetrieval{" +
                "id='" + id + '\'' +
                ", projectId='" + projectId + '\'' +
                ", projectName='" + projectName + '\'' +
                ", personCharge='" + personCharge + '\'' +
                ", functionCode=" + functionCode +
                ", functionName='" + functionName + '\'' +
                ", archivesType=" + archivesType +
                ", bizTableName='" + bizTableName + '\'' +
                ", bizDataId='" + bizDataId + '\'' +
                ", detailsRoteUrl='" + detailsRoteUrl + '\'' +
                ", tableRoteUrl='" + tableRoteUrl + '\'' +
                ", tableApiUrl='" + tableApiUrl + '\'' +
                ", detailsApiUrl='" + detailsApiUrl + '\'' +
                ", functionPath='" + functionPath + '\'' +
                ", name='" + name + '\'' +
                ", documentNumber='" + documentNumber + '\'' +
                ", documentUnit='" + documentUnit + '\'' +
                ", certificateNumber='" + certificateNumber + '\'' +
                ", certificateUnit='" + certificateUnit + '\'' +
                ", fileType=" + fileType +
                ", fileName='" + fileName + '\'' +
                ", fileSourceId='" + fileSourceId + '\'' +
                ", fileUrl='" + fileUrl + '\'' +
                ", fileSuffix='" + fileSuffix + '\'' +
                ", fileGroup='" + fileGroup + '\'' +
                ", fileSize='" + fileSize + '\'' +
                ", searchTitle='" + searchTitle + '\'' +
                '}';
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getPersonCharge() {
        return personCharge;
    }

    public void setPersonCharge(String personCharge) {
        this.personCharge = personCharge;
    }



    public Integer getArchivesType() {
        return archivesType;
    }

    public void setArchivesType(Integer archivesType) {
        this.archivesType = archivesType;
    }

    public String getBizTableName() {
        return bizTableName;
    }

    public String getFunctionCode() {
        return functionCode;
    }

    public void setFunctionCode(String functionCode) {
        this.functionCode = functionCode;
    }

    public String getFunctionName() {
        return functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public void setBizTableName(String bizTableName) {
        this.bizTableName = bizTableName;
    }

    public String getBizDataId() {
        return bizDataId;
    }

    public void setBizDataId(String bizDataId) {
        this.bizDataId = bizDataId;
    }

    public String getDetailsRoteUrl() {
        return detailsRoteUrl;
    }

    public void setDetailsRoteUrl(String detailsRoteUrl) {
        this.detailsRoteUrl = detailsRoteUrl;
    }

    public String getTableRoteUrl() {
        return tableRoteUrl;
    }

    public void setTableRoteUrl(String tableRoteUrl) {
        this.tableRoteUrl = tableRoteUrl;
    }

    public String getTableApiUrl() {
        return tableApiUrl;
    }

    public void setTableApiUrl(String tableApiUrl) {
        this.tableApiUrl = tableApiUrl;
    }

    public String getDetailsApiUrl() {
        return detailsApiUrl;
    }

    public void setDetailsApiUrl(String detailsApiUrl) {
        this.detailsApiUrl = detailsApiUrl;
    }

    public String getFunctionPath() {
        return functionPath;
    }

    public void setFunctionPath(String functionPath) {
        this.functionPath = functionPath;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDocumentNumber() {
        return documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public String getDocumentUnit() {
        return documentUnit;
    }

    public void setDocumentUnit(String documentUnit) {
        this.documentUnit = documentUnit;
    }

    public String getCertificateNumber() {
        return certificateNumber;
    }

    public void setCertificateNumber(String certificateNumber) {
        this.certificateNumber = certificateNumber;
    }

    public String getCertificateUnit() {
        return certificateUnit;
    }

    public void setCertificateUnit(String certificateUnit) {
        this.certificateUnit = certificateUnit;
    }

    public Integer getFileType() {
        return fileType;
    }

    public void setFileType(Integer fileType) {
        this.fileType = fileType;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileSourceId() {
        return fileSourceId;
    }

    public void setFileSourceId(String fileSourceId) {
        this.fileSourceId = fileSourceId;
    }

    public String getFileUrl() {
        return fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public String getFileSuffix() {
        return fileSuffix;
    }

    public void setFileSuffix(String fileSuffix) {
        this.fileSuffix = fileSuffix;
    }

    public String getFileGroup() {
        return fileGroup;
    }

    public void setFileGroup(String fileGroup) {
        this.fileGroup = fileGroup;
    }

    public String getFileSize() {
        return fileSize;
    }

    public void setFileSize(String fileSize) {
        this.fileSize = fileSize;
    }

    public String getSearchTitle() {
        return searchTitle;
    }

    public void setSearchTitle(String searchTitle) {
        this.searchTitle = searchTitle;
    }
}

